/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.stage;

import com.alipay.sofa.isle.ApplicationRuntimeModel;
import com.alipay.sofa.isle.deployment.DependencyTree;
import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import com.alipay.sofa.isle.deployment.DeploymentException;
import com.alipay.sofa.isle.loader.DynamicSpringContextLoader;
import com.alipay.sofa.isle.loader.SpringContextLoader;
import com.alipay.sofa.isle.spring.config.SofaModuleProperties;
import com.alipay.sofa.isle.stage.AbstractPipelineStage;
import com.alipay.sofa.isle.utils.NamedThreadFactory;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.StringUtils;

public class SpringContextInstallStage
extends AbstractPipelineStage {
    private static final String SYMBOLIC1 = "  \u251c\u2500 ";
    private static final String SYMBOLIC2 = "  \u2514\u2500 ";
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();

    public SpringContextInstallStage(AbstractApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    protected void doProcess() throws Exception {
        ApplicationRuntimeModel application = (ApplicationRuntimeModel)this.applicationContext.getBean("SOFABOOT-APPLICATION", ApplicationRuntimeModel.class);
        try {
            this.doProcess(application);
        }
        catch (Throwable e) {
            SofaLogger.error((Throwable)e, (String)"Install Spring Context got an error.", (Object[])new Object[0]);
            throw new DeploymentException("Install Spring Context got an error.", e);
        }
    }

    private void doProcess(ApplicationRuntimeModel application) throws Exception {
        this.outputModulesMessage(application);
        SpringContextLoader springContextLoader = this.createSpringContextLoader();
        this.installSpringContext(application, springContextLoader);
        if (((SofaModuleProperties)this.applicationContext.getBean("sofaModuleProperties", SofaModuleProperties.class)).isModuleStartUpParallel()) {
            this.refreshSpringContextParallel(application);
        } else {
            this.refreshSpringContext(application);
        }
    }

    protected SpringContextLoader createSpringContextLoader() {
        return new DynamicSpringContextLoader((ApplicationContext)this.applicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSpringContext(ApplicationRuntimeModel application, SpringContextLoader springContextLoader) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        for (DeploymentDescriptor deployment : application.getResolvedDeployments()) {
            if (!deployment.isSpringPowered()) continue;
            SofaLogger.info((String)("Start install " + application.getAppName() + "'s module: " + deployment.getName()), (Object[])new Object[0]);
            try {
                Thread.currentThread().setContextClassLoader(deployment.getClassLoader());
                springContextLoader.loadSpringContext(deployment, application);
            }
            catch (Throwable e) {
                SofaLogger.error((Throwable)e, (String)"Install module {0} got an error!", (Object[])new Object[]{deployment.getName()});
                application.addFailed(deployment);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    private void outputModulesMessage(ApplicationRuntimeModel application) throws DeploymentException {
        StringBuilder stringBuilder = new StringBuilder();
        if (application.getAllInactiveDeployments().size() > 0) {
            this.writeMessageToStringBuilder(stringBuilder, application.getAllInactiveDeployments(), "All unactivated module list");
        }
        this.writeMessageToStringBuilder(stringBuilder, application.getAllDeployments(), "All activated module list");
        this.writeMessageToStringBuilder(stringBuilder, application.getResolvedDeployments(), "Modules that could install");
        SofaLogger.info((String)stringBuilder.toString(), (Object[])new Object[0]);
        String errorMessage = this.getErrorMessageByApplicationModule(application);
        if (StringUtils.hasText((String)errorMessage)) {
            SofaLogger.error((String)errorMessage, (Object[])new Object[0]);
        }
        if (application.getDeployRegistry().getPendingEntries().size() > 0) {
            throw new DeploymentException(errorMessage.trim());
        }
    }

    private String getErrorMessageByApplicationModule(ApplicationRuntimeModel application) {
        StringBuilder sbError = new StringBuilder(512);
        if (application.getDeployRegistry().getPendingEntries().size() > 0) {
            sbError.append("\nModules that could not install(Mainly due to module dependency not satisfied.)").append("(").append(application.getDeployRegistry().getPendingEntries().size()).append(") >>>>>>>>\n");
        }
        for (DependencyTree.Entry<String, DeploymentDescriptor> entry : application.getDeployRegistry().getPendingEntries()) {
            if (!application.getAllDeployments().contains(entry.get())) continue;
            sbError.append("[").append(entry.getKey()).append("]").append(" depends on ").append(entry.getWaitsFor()).append(", but the latter can not be resolved.").append("\n");
        }
        return sbError.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSpringContext(ApplicationRuntimeModel application) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (DeploymentDescriptor deployment : application.getResolvedDeployments()) {
                if (!deployment.isSpringPowered() || application.getFailed().contains(deployment)) continue;
                Thread.currentThread().setContextClassLoader(deployment.getClassLoader());
                this.doRefreshSpringContext(deployment, application);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSpringContextParallel(ApplicationRuntimeModel application) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<DeploymentDescriptor> coreRoots = new ArrayList<DeploymentDescriptor>();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(CPU_COUNT + 1, CPU_COUNT + 1, 60L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("sofa-module-start"), new ThreadPoolExecutor.CallerRunsPolicy());
        try {
            for (DeploymentDescriptor deployment : application.getResolvedDeployments()) {
                DependencyTree.Entry<String, DeploymentDescriptor> entry = application.getDeployRegistry().getEntry(deployment.getModuleName());
                if (entry == null || entry.getDependencies() != null) continue;
                coreRoots.add(deployment);
            }
            this.refreshSpringContextParallel(coreRoots, application.getResolvedDeployments().size(), application, executor);
        }
        finally {
            executor.shutdown();
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void refreshSpringContextParallel(List<DeploymentDescriptor> rootDeployments, int totalSize, ApplicationRuntimeModel application, ThreadPoolExecutor executor) {
        if (rootDeployments == null || rootDeployments.size() == 0) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(totalSize);
        CopyOnWriteArrayList<Future> futures = new CopyOnWriteArrayList<Future>();
        for (DeploymentDescriptor deployment : rootDeployments) {
            this.refreshSpringContextParallel(deployment, application, executor, latch, futures);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Wait for Sofa Module Refresh Fail", e);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void refreshSpringContextParallel(final DeploymentDescriptor deployment, final ApplicationRuntimeModel application, final ThreadPoolExecutor executor, final CountDownLatch latch, final List<Future> futures) {
        futures.add(executor.submit(new Runnable(){

            @Override
            public void run() {
                String oldName = Thread.currentThread().getName();
                try {
                    DependencyTree.Entry<String, DeploymentDescriptor> entry;
                    Thread.currentThread().setName("sofa-module-start-" + deployment.getModuleName());
                    Thread.currentThread().setContextClassLoader(deployment.getClassLoader());
                    if (deployment.isSpringPowered() && !application.getFailed().contains(deployment)) {
                        SpringContextInstallStage.this.doRefreshSpringContext(deployment, application);
                    }
                    if ((entry = application.getDeployRegistry().getEntry(deployment.getModuleName())) != null && entry.getDependsOnMe() != null) {
                        for (DependencyTree.Entry<String, DeploymentDescriptor> child : entry.getDependsOnMe()) {
                            child.getDependencies().remove(entry);
                            if (child.getDependencies().size() != 0) continue;
                            SpringContextInstallStage.this.refreshSpringContextParallel(child.get(), application, executor, latch, futures);
                        }
                    }
                }
                catch (Throwable e) {
                    SofaLogger.error((Throwable)e, (String)("Refreshing Spring Application Context of module {0} got an error." + deployment.getName()), (Object[])new Object[0]);
                    throw new RuntimeException("Refreshing Spring Application Context of module " + deployment.getName() + " got an error.", e);
                }
                finally {
                    latch.countDown();
                    Thread.currentThread().setName(oldName);
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshSpringContext(DeploymentDescriptor deployment, ApplicationRuntimeModel application) {
        SofaLogger.info((String)"Begin refresh Spring Application Context of module {0} of application {1}.", (Object[])new Object[]{deployment.getName(), application.getAppName()});
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)deployment.getApplicationContext();
        if (ctx != null) {
            try {
                deployment.startDeploy();
                ctx.refresh();
                application.addInstalled(deployment);
            }
            catch (Throwable t) {
                SofaLogger.error((Throwable)t, (String)"Refreshing Spring Application Context of module {0} got an error.", (Object[])new Object[]{deployment.getName()});
                application.addFailed(deployment);
            }
            finally {
                deployment.deployFinish();
            }
        } else {
            application.addFailed(deployment);
            SofaLogger.error((Throwable)new RuntimeException("Spring Application Context of module " + deployment.getName() + " is null!"), (String)"", (Object[])new Object[0]);
        }
    }

    private void writeMessageToStringBuilder(StringBuilder sb, List<DeploymentDescriptor> deploys, String info) {
        sb.append("\n").append(info).append("(").append(deploys.size()).append(") >>>>>>>\n");
        Iterator<DeploymentDescriptor> i = deploys.iterator();
        while (i.hasNext()) {
            DeploymentDescriptor dd = i.next();
            String treeSymbol = SYMBOLIC1;
            if (!i.hasNext()) {
                treeSymbol = SYMBOLIC2;
            }
            sb.append(treeSymbol).append(dd.getName()).append("\n");
        }
    }

    @Override
    public String getName() {
        return "SpringContextInstallStage";
    }

    public int getOrder() {
        return 20000;
    }
}

