/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.isle.utils;

import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import com.alipay.sofa.isle.profile.DefaultSofaModuleProfileEnvironment;
import com.alipay.sofa.isle.profile.SofaModuleProfileEnvironment;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.context.ApplicationContext;

public class SofaModuleProfileUtil {
    private static final ConcurrentMap<ApplicationContext, SofaModuleProfileEnvironment> map = new ConcurrentHashMap<ApplicationContext, SofaModuleProfileEnvironment>();

    public static boolean acceptProfile(ApplicationContext applicationContext, DeploymentDescriptor dd) {
        SofaModuleProfileEnvironment sofaProfileEnvironment = SofaModuleProfileUtil.createSofaProfileEnvironment(applicationContext);
        return sofaProfileEnvironment.acceptsProfiles(SofaModuleProfileUtil.getActiveModuleProfiles(dd));
    }

    private static SofaModuleProfileEnvironment createSofaProfileEnvironment(ApplicationContext applicationContext) {
        SofaModuleProfileEnvironment environment = (SofaModuleProfileEnvironment)map.get(applicationContext);
        if (environment == null) {
            environment = new DefaultSofaModuleProfileEnvironment();
            environment.initEnvironment(applicationContext);
            SofaModuleProfileEnvironment oldEnvironment = map.putIfAbsent(applicationContext, environment);
            if (oldEnvironment != null) {
                environment = oldEnvironment;
            }
        }
        return environment;
    }

    private static String[] getActiveModuleProfiles(DeploymentDescriptor deploymentDescriptor) {
        String[] activeModuleProfiles = new String[]{"default"};
        String profiles = deploymentDescriptor.getProperty("Module-Profile");
        if (profiles == null || profiles.length() == 0) {
            return activeModuleProfiles;
        }
        activeModuleProfiles = profiles.split(",");
        return activeModuleProfiles;
    }
}

