/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.arklet.springboot.starter.health;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.event.AbstractArkEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStartupEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStartupFailedEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStopEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizStartupEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizStopEvent;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import com.alipay.sofa.koupleless.common.util.SpringUtils;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.ApplicationAvailabilityBean;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.LivenessState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.context.ApplicationContext;

public class BaseProbeAvailabilityStateHandler
implements EventHandler<AbstractArkEvent> {
    private final CopyOnWriteArraySet<Biz> startingBizSet = new CopyOnWriteArraySet();
    private boolean associateWithAllBizReadiness;
    private int silenceSecondsBeforeUninstall;
    private ApplicationContext baseContext;
    private final ApplicationAvailability applicationAvailability;

    public BaseProbeAvailabilityStateHandler(ApplicationContext applicationContext, boolean withAllBizReadiness, int silenceSecondsBeforeUninstall) {
        this.baseContext = applicationContext;
        this.associateWithAllBizReadiness = withAllBizReadiness;
        this.applicationAvailability = (ApplicationAvailability)this.baseContext.getBean("applicationAvailability");
        this.silenceSecondsBeforeUninstall = silenceSecondsBeforeUninstall;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void handleEvent(AbstractArkEvent event) {
        Object obj = event.getSource();
        if (obj instanceof Biz) {
            Biz biz = (Biz)obj;
            this.handleBizEvent((AbstractArkEvent<Biz>)event, biz);
        }
    }

    private void handleBizEvent(AbstractArkEvent<Biz> event, Biz biz) {
        if (biz == ArkClient.getMasterBiz()) {
            return;
        }
        if (!this.associateWithAllBizReadiness) {
            return;
        }
        if (event instanceof BeforeBizStartupEvent) {
            AvailabilityChangeEvent.publish((ApplicationContext)this.baseContext, (AvailabilityState)ReadinessState.REFUSING_TRAFFIC);
            this.startingBizSet.add(biz);
            return;
        }
        if (event instanceof AfterBizStartupFailedEvent) {
            AvailabilityChangeEvent.publish((ApplicationContext)this.baseContext, (AvailabilityState)ReadinessState.REFUSING_TRAFFIC);
            return;
        }
        if (event instanceof AfterBizStartupEvent) {
            if (this.applicationAvailability.getLivenessState() == LivenessState.CORRECT && this.getCompositeStartingBizReadiness() == ReadinessState.ACCEPTING_TRAFFIC) {
                AvailabilityChangeEvent.publish((ApplicationContext)this.baseContext, (AvailabilityState)ReadinessState.ACCEPTING_TRAFFIC);
            }
            return;
        }
        if (event instanceof BeforeBizStopEvent) {
            AvailabilityChangeEvent.publish((ApplicationContext)this.baseContext, (AvailabilityState)ReadinessState.REFUSING_TRAFFIC);
            this.silenceBeforeUninstall(this.silenceSecondsBeforeUninstall);
            return;
        }
        if (event instanceof AfterBizStopEvent) {
            this.startingBizSet.remove(biz);
        }
    }

    private void silenceBeforeUninstall(int seconds) {
        if (seconds > 0) {
            try {
                Thread.sleep((long)seconds * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ReadinessState getCompositeStartingBizReadiness() {
        if (this.startingBizSet.stream().allMatch(biz -> this.getReadinessState((Biz)biz) == ReadinessState.ACCEPTING_TRAFFIC)) {
            return ReadinessState.ACCEPTING_TRAFFIC;
        }
        return ReadinessState.REFUSING_TRAFFIC;
    }

    private ReadinessState getReadinessState(Biz biz) {
        try {
            ApplicationAvailabilityBean applicationAvailability = (ApplicationAvailabilityBean)SpringUtils.getBean((Biz)biz, (String)"applicationAvailability");
            return applicationAvailability.getReadinessState();
        }
        catch (Exception e) {
            return ReadinessState.REFUSING_TRAFFIC;
        }
    }
}

