/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.arklet.springboot.starter.health;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.event.AbstractArkEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStartupEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStartupFailedEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStopEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizStartupEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizStopEvent;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationListener;

public class BaseStartUpHealthIndicator
extends AbstractHealthIndicator
implements EventHandler<AbstractArkEvent>,
ApplicationListener<SpringApplicationEvent> {
    private Status baseStartUpStatus = Status.UNKNOWN;
    private final ConcurrentHashMap<String, Status> bizStartUpStatus = new ConcurrentHashMap();
    private boolean associateWithAllBizReadiness;
    public Method healthBuildWithDetails = null;
    private int silenceSecondsBeforeUninstall;

    public BaseStartUpHealthIndicator(boolean withAllBizReadiness, int silenceSecondsBeforeUninstall) {
        try {
            this.healthBuildWithDetails = Health.Builder.class.getMethod("withDetails", Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.associateWithAllBizReadiness = withAllBizReadiness;
        this.silenceSecondsBeforeUninstall = silenceSecondsBeforeUninstall;
    }

    public void handleEvent(AbstractArkEvent event) {
        Object obj = event.getSource();
        if (obj instanceof Biz) {
            Biz biz = (Biz)obj;
            this.handleBizEvent((AbstractArkEvent<Biz>)event, biz);
        }
    }

    private void handleBizEvent(AbstractArkEvent<Biz> event, Biz biz) {
        if (biz == ArkClient.getMasterBiz()) {
            return;
        }
        if (event instanceof BeforeBizStartupEvent) {
            this.bizStartUpStatus.put(biz.getIdentity(), Status.UNKNOWN);
        } else if (event instanceof AfterBizStartupEvent) {
            this.bizStartUpStatus.put(biz.getIdentity(), Status.UP);
        } else if (event instanceof AfterBizStartupFailedEvent) {
            this.bizStartUpStatus.put(biz.getIdentity(), Status.DOWN);
        } else if (event instanceof BeforeBizStopEvent) {
            this.bizStartUpStatus.put(biz.getIdentity(), Status.DOWN);
            this.silenceBeforeUninstall(this.silenceSecondsBeforeUninstall);
        } else if (event instanceof AfterBizStopEvent) {
            this.bizStartUpStatus.remove(biz.getIdentity());
        }
    }

    private void silenceBeforeUninstall(int seconds) {
        if (seconds > 0) {
            try {
                Thread.sleep((long)seconds * 1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void onApplicationEvent(SpringApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.baseStartUpStatus = Status.UP;
        } else if (event instanceof ApplicationFailedEvent) {
            this.baseStartUpStatus = Status.DOWN;
        }
    }

    protected void doHealthCheck(Health.Builder builder) {
        block10: {
            block9: {
                builder.withDetail(ArkClient.getMasterBiz().getIdentity(), (Object)this.baseStartUpStatus);
                if (this.healthBuildWithDetails != null) {
                    try {
                        this.healthBuildWithDetails.invoke((Object)builder, this.bizStartUpStatus);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!this.associateWithAllBizReadiness) {
                    builder.status(this.baseStartUpStatus);
                    return;
                }
                if (this.baseStartUpStatus == Status.UP) {
                    if (this.bizStartUpStatus.values().stream().allMatch(arg_0 -> ((Status)Status.UP).equals(arg_0))) {
                        builder.status(Status.UP);
                        return;
                    }
                }
                if (this.baseStartUpStatus == Status.UNKNOWN) break block9;
                if (!this.bizStartUpStatus.values().stream().anyMatch(arg_0 -> ((Status)Status.UNKNOWN).equals(arg_0))) break block10;
            }
            builder.status(Status.UNKNOWN);
            return;
        }
        builder.status(Status.DOWN);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

