/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.arklet.springboot.starter.health;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.koupleless.common.BizRuntimeContextRegistry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class CompositeAllBizHealthIndicator
extends AbstractHealthIndicator {
    public Method healthBuildWithDetails = null;

    public CompositeAllBizHealthIndicator() {
        try {
            this.healthBuildWithDetails = Health.Builder.class.getDeclaredMethod("withDetails", Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        HashMap<String, Health> bizHealthMap = this.aggregateBizHealth();
        builder.up();
        if (this.healthBuildWithDetails != null) {
            this.healthBuildWithDetails.invoke((Object)builder, bizHealthMap);
        }
        if (bizHealthMap.values().stream().map(Health::getStatus).anyMatch(arg_0 -> ((Status)Status.DOWN).equals(arg_0))) {
            builder.down();
        } else if (bizHealthMap.values().stream().map(Health::getStatus).anyMatch(arg_0 -> ((Status)Status.UNKNOWN).equals(arg_0))) {
            builder.unknown();
        }
    }

    private HashMap<String, Health> aggregateBizHealth() {
        HashMap<String, Health> bizHealthMap = new HashMap<String, Health>();
        ConcurrentHashMap runtimeMap = BizRuntimeContextRegistry.getRuntimeMap();
        runtimeMap.forEach((classLoader, bizRuntimeContext) -> {
            Map bizIndicators;
            if (classLoader == ArkClient.getMasterBiz().getBizClassLoader()) {
                return;
            }
            Health.Builder bizBuilder = new Health.Builder().up();
            Biz biz = ArkClient.getBizManagerService().getBizByClassLoader(classLoader);
            try {
                bizIndicators = bizRuntimeContext.getRootApplicationContext().getBeansOfType(HealthIndicator.class);
            }
            catch (Exception e) {
                bizBuilder.down();
                bizBuilder.withDetail("applicationContext", (Object)"haven't refreshed");
                Health bizHealth = bizBuilder.build();
                bizHealthMap.put(biz.getIdentity(), bizHealth);
                return;
            }
            bizIndicators.forEach((bizIndicatorBeanName, bizIndicator) -> {
                String bizIndicatorName = bizIndicatorBeanName.substring(0, bizIndicatorBeanName.length() - "HealthIndicator".length());
                Health bizIndicatorHealth = bizIndicator.health();
                HashMap bizIndicatorDetails = new HashMap();
                bizIndicatorDetails.put("details", bizIndicatorHealth.getDetails());
                bizIndicatorDetails.put("status", bizIndicatorHealth.getStatus());
                bizBuilder.withDetail(bizIndicatorName, bizIndicatorDetails);
                if (bizIndicatorHealth.getStatus().equals((Object)Status.DOWN)) {
                    bizBuilder.down();
                } else if (bizIndicatorHealth.getStatus().equals((Object)Status.UNKNOWN)) {
                    bizBuilder.unknown();
                }
            });
            Health bizHealth = bizBuilder.build();
            bizHealthMap.put(biz.getIdentity(), bizHealth);
        });
        return bizHealthMap;
    }
}

