/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.arklet.springboot.starter.health;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import com.alipay.sofa.koupleless.arklet.springboot.starter.health.BaseStartUpHealthIndicator;
import com.alipay.sofa.koupleless.arklet.springboot.starter.health.BizInfoContributor;
import com.alipay.sofa.koupleless.arklet.springboot.starter.health.CompositeAllBizHealthIndicator;
import com.alipay.sofa.koupleless.arklet.springboot.starter.health.MetricsHealthIndicator;
import com.alipay.sofa.koupleless.arklet.springboot.starter.properties.ArkletProperties;
import com.alipay.sofa.koupleless.common.environment.ConditionalOnMasterBiz;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnMasterBiz
@EnableConfigurationProperties(value={ArkletProperties.class})
public class HealthAutoConfiguration {
    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.info.InfoContributor"})
    public BizInfoContributor bizInfoContributor() {
        return new BizInfoContributor();
    }

    @Bean(value={"baseStartUpHealthIndicator"})
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.AbstractHealthIndicator"})
    public BaseStartUpHealthIndicator baseStartUpHealthIndicator(Environment masterBizEnvironment, ArkletProperties arkletProperties) {
        BaseStartUpHealthIndicator indicator = new BaseStartUpHealthIndicator(Boolean.parseBoolean(masterBizEnvironment.getProperty("koupleless.healthcheck.base.readiness.withAllBizReadiness", "false")), arkletProperties.getOperation().getSilenceSecondsBeforeUninstall());
        ArkClient.getEventAdminService().register((EventHandler)indicator);
        return indicator;
    }

    @Bean(value={"compositeAllBizHealthIndicator"})
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.AbstractHealthIndicator"})
    public CompositeAllBizHealthIndicator compositeAllBizHealthIndicator() {
        return new CompositeAllBizHealthIndicator();
    }

    @Bean(value={"metricsHealthIndicator"})
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.AbstractHealthIndicator"})
    public MetricsHealthIndicator metricsHealthIndicator(ArkletProperties arkletProperties) {
        return new MetricsHealthIndicator(arkletProperties.getMonitor());
    }
}

