/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.arklet.springboot.starter.health;

import com.alipay.sofa.koupleless.arklet.core.monitor.MetricsMonitor;
import com.alipay.sofa.koupleless.arklet.core.monitor.model.ClientMetrics;
import com.alipay.sofa.koupleless.arklet.springboot.starter.properties.ArkletProperties;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class MetricsHealthIndicator
extends AbstractHealthIndicator {
    private final ArkletProperties.MonitorProperties monitorProperties;

    public MetricsHealthIndicator(ArkletProperties.MonitorProperties monitorProperties) {
        this.monitorProperties = monitorProperties;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        ClientMetrics clientMetrics = MetricsMonitor.captureMetrics();
        builder.withDetail("metrics", (Object)clientMetrics);
        if (this.unhealthy(clientMetrics)) {
            builder.down();
        } else {
            builder.up();
        }
    }

    private boolean unhealthy(ClientMetrics clientMetrics) {
        return this.monitorProperties.isMetaspaceCheck() && !MetricsMonitor.validateMetaspace((long)this.monitorProperties.getMetaspaceThreshold(), (ClientMetrics)clientMetrics);
    }
}

