/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.arklet.springboot.starter.health;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import com.alipay.sofa.koupleless.arklet.springboot.starter.health.BaseProbeAvailabilityStateHandler;
import com.alipay.sofa.koupleless.arklet.springboot.starter.health.ProbeAvailabilityStateIndicator;
import com.alipay.sofa.koupleless.arklet.springboot.starter.properties.ArkletProperties;
import com.alipay.sofa.koupleless.common.environment.ConditionalOnMasterBiz;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnMasterBiz
@ConditionalOnClass(name={"org.springframework.boot.availability.ApplicationAvailability"})
@EnableConfigurationProperties(value={ArkletProperties.class})
public class ProbeAutoConfiguration {
    @Bean
    public ProbeAvailabilityStateIndicator probeAvailabilityStateIndicator(ApplicationContext applicationContext) {
        return new ProbeAvailabilityStateIndicator(applicationContext);
    }

    @Bean
    public BaseProbeAvailabilityStateHandler baseProbeAvailabilityStateHandler(ApplicationContext applicationContext, Environment env, ArkletProperties arkletProperties) {
        BaseProbeAvailabilityStateHandler handler = new BaseProbeAvailabilityStateHandler(applicationContext, Boolean.parseBoolean(env.getProperty("koupleless.healthcheck.base.readiness.withAllBizReadiness", "false")), arkletProperties.getOperation().getSilenceSecondsBeforeUninstall());
        ArkClient.getEventAdminService().register((EventHandler)handler);
        return handler;
    }
}

