/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.arklet.springboot.starter.health;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.koupleless.common.util.SpringUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.ApplicationAvailabilityBean;
import org.springframework.boot.availability.LivenessState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.context.ApplicationContext;

public class ProbeAvailabilityStateIndicator
extends AbstractHealthIndicator {
    private final ApplicationAvailability applicationAvailability;

    public ProbeAvailabilityStateIndicator(ApplicationContext applicationContext) {
        super("");
        this.applicationAvailability = (ApplicationAvailability)applicationContext.getBean("applicationAvailability");
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.up();
        builder.withDetail("baseAvailability", (Object)BizAvailabilityState.build(this.applicationAvailability));
        builder.withDetail("bizAvailability", this.getAllBizAvailabilityState());
    }

    private Map<String, BizAvailabilityState> getAllBizAvailabilityState() {
        HashMap<String, BizAvailabilityState> bizAvailabilityStates = new HashMap<String, BizAvailabilityState>();
        for (Biz biz : ArkClient.getBizManagerService().getBizInOrder()) {
            bizAvailabilityStates.put(biz.getIdentity(), this.getBizAvailabilityState(biz));
        }
        return bizAvailabilityStates;
    }

    private BizAvailabilityState getBizAvailabilityState(Biz biz) {
        try {
            ApplicationAvailabilityBean applicationAvailability = (ApplicationAvailabilityBean)SpringUtils.getBean((Biz)biz, (String)"applicationAvailability");
            return BizAvailabilityState.build((ApplicationAvailability)applicationAvailability);
        }
        catch (Exception e) {
            return new BizAvailabilityState(LivenessState.BROKEN, ReadinessState.REFUSING_TRAFFIC);
        }
    }

    private static class BizAvailabilityState {
        private LivenessState livenessState;
        private ReadinessState readinessState;

        public static BizAvailabilityState build(ApplicationAvailability applicationAvailability) {
            return new BizAvailabilityState(applicationAvailability.getLivenessState(), applicationAvailability.getReadinessState());
        }

        public boolean isHealthy() {
            return this.livenessState == LivenessState.CORRECT && this.readinessState == ReadinessState.ACCEPTING_TRAFFIC;
        }

        public BizAvailabilityState(LivenessState livenessState, ReadinessState readinessState) {
            this.livenessState = livenessState;
            this.readinessState = readinessState;
        }

        public LivenessState getLivenessState() {
            return this.livenessState;
        }

        public ReadinessState getReadinessState() {
            return this.readinessState;
        }

        public void setLivenessState(LivenessState livenessState) {
            this.livenessState = livenessState;
        }

        public void setReadinessState(ReadinessState readinessState) {
            this.readinessState = readinessState;
        }

        public BizAvailabilityState() {
        }
    }
}

