/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.adapter;

import com.alipay.sofa.koupleless.common.util.ArkUtils;
import com.alipay.sofa.koupleless.common.util.MultiBizProperties;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@ConditionalOnBean(type={"com.ctrip.framework.apollo.spring.boot.ApolloApplicationContextInitializer"})
@ConditionalOnClass(name={"com.ctrip.framework.apollo.spring.boot.ApolloApplicationContextInitializer"})
public class ApolloPropertiesClearInitializer
implements EnvironmentPostProcessor,
Ordered {
    private int order = -1;
    private static final String[] NEED_CLEAR_PROPERTIES = new String[]{"app.id", "apollo.cacheDir", "apollo.accesskey.secret", "apollo.property.order.enable"};

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MultiBizProperties.initSystem();
        if (ArkUtils.isModuleBiz()) {
            this.clearApolloSystemProperties(environment);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private void clearApolloSystemProperties(ConfigurableEnvironment environment) {
        List<String> propertiesToClear = this.apolloPropertiesConfiguredInBizEnvironment(environment);
        propertiesToClear.forEach(System::clearProperty);
    }

    private List<String> apolloPropertiesConfiguredInBizEnvironment(ConfigurableEnvironment environment) {
        ArrayList properties = Lists.newArrayList();
        List<PropertySource> notSystemPropertySources = environment.getPropertySources().stream().filter(it -> {
            String name = it.getName();
            boolean notSystemProp = !"systemProperties".equals(name);
            boolean notSystemEnv = !"systemEnvironment".equals(name);
            return notSystemProp && notSystemEnv;
        }).collect(Collectors.toList());
        notSystemPropertySources.forEach(it -> {
            for (String key : NEED_CLEAR_PROPERTIES) {
                if (StringUtils.isEmpty((Object)it.getProperty(key))) continue;
                properties.add(key);
            }
        });
        return properties;
    }
}

