/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.slf4j.EventDataConverter;
import org.apache.logging.slf4j.Log4jMarker;
import org.apache.logging.slf4j.Log4jMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.impl.StaticMarkerBinder;
import org.slf4j.spi.LocationAwareLogger;

public class Log4jLogger
implements LocationAwareLogger,
Serializable {
    public static final String FQCN = Log4jLogger.class.getName();
    private static final long serialVersionUID = 7869000638091304316L;
    private static final Marker EVENT_MARKER = MarkerFactory.getMarker((String)"EVENT");
    private static final EventDataConverter CONVERTER = Log4jLogger.createConverter();
    private final boolean eventLogger;
    private final transient Map<ClassLoader, ExtendedLogger> loggerMap = new ConcurrentHashMap<ClassLoader, ExtendedLogger>();
    private static final Map<ClassLoader, LoggerContext> LOGGER_CONTEXT_MAP = new ConcurrentHashMap<ClassLoader, LoggerContext>();
    private final String name;

    public Log4jLogger(ExtendedLogger logger, String name) {
        this.eventLogger = "EventLogger".equals(name);
        this.name = name;
    }

    public void trace(String format) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, null, format);
    }

    public void trace(String format, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, null, format, o);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, null, format, arg1, arg2);
    }

    public void trace(String format, Object ... args) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, null, format, args);
    }

    public void trace(String format, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, null, format, t);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isEnabled(Level.TRACE, null, null);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.getLogger().isEnabled(Level.TRACE, Log4jLogger.getMarker(marker), null);
    }

    public void trace(Marker marker, String s) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s);
    }

    public void trace(Marker marker, String s, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s, o);
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s, o, o1);
    }

    public void trace(Marker marker, String s, Object ... objects) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s, objects);
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        this.getLogger().logIfEnabled(FQCN, Level.TRACE, Log4jLogger.getMarker(marker), s, throwable);
    }

    public void debug(String format) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, null, format);
    }

    public void debug(String format, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, null, format, o);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, null, format, arg1, arg2);
    }

    public void debug(String format, Object ... args) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, null, format, args);
    }

    public void debug(String format, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, null, format, t);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isEnabled(Level.DEBUG, null, null);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.getLogger().isEnabled(Level.DEBUG, Log4jLogger.getMarker(marker), null);
    }

    public void debug(Marker marker, String s) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s);
    }

    public void debug(Marker marker, String s, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s, o);
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s, o, o1);
    }

    public void debug(Marker marker, String s, Object ... objects) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s, objects);
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        this.getLogger().logIfEnabled(FQCN, Level.DEBUG, Log4jLogger.getMarker(marker), s, throwable);
    }

    public void info(String format) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, null, format);
    }

    public void info(String format, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, null, format, o);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, null, format, arg1, arg2);
    }

    public void info(String format, Object ... args) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, null, format, args);
    }

    public void info(String format, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, null, format, t);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isEnabled(Level.INFO, null, null);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.getLogger().isEnabled(Level.INFO, Log4jLogger.getMarker(marker), null);
    }

    public void info(Marker marker, String s) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s);
    }

    public void info(Marker marker, String s, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s, o);
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s, o, o1);
    }

    public void info(Marker marker, String s, Object ... objects) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s, objects);
    }

    public void info(Marker marker, String s, Throwable throwable) {
        this.getLogger().logIfEnabled(FQCN, Level.INFO, Log4jLogger.getMarker(marker), s, throwable);
    }

    public void warn(String format) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, null, format);
    }

    public void warn(String format, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, null, format, o);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, null, format, arg1, arg2);
    }

    public void warn(String format, Object ... args) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, null, format, args);
    }

    public void warn(String format, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, null, format, t);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isEnabled(Level.WARN, null, null);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.getLogger().isEnabled(Level.WARN, Log4jLogger.getMarker(marker), null);
    }

    public void warn(Marker marker, String s) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s);
    }

    public void warn(Marker marker, String s, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s, o);
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s, o, o1);
    }

    public void warn(Marker marker, String s, Object ... objects) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s, objects);
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        this.getLogger().logIfEnabled(FQCN, Level.WARN, Log4jLogger.getMarker(marker), s, throwable);
    }

    public void error(String format) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, null, format);
    }

    public void error(String format, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, null, format, o);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, null, format, arg1, arg2);
    }

    public void error(String format, Object ... args) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, null, format, args);
    }

    public void error(String format, Throwable t) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, null, format, t);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isEnabled(Level.ERROR, null, null);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.getLogger().isEnabled(Level.ERROR, Log4jLogger.getMarker(marker), null);
    }

    public void error(Marker marker, String s) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s);
    }

    public void error(Marker marker, String s, Object o) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s, o);
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s, o, o1);
    }

    public void error(Marker marker, String s, Object ... objects) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s, objects);
    }

    public void error(Marker marker, String s, Throwable throwable) {
        this.getLogger().logIfEnabled(FQCN, Level.ERROR, Log4jLogger.getMarker(marker), s, throwable);
    }

    public void log(Marker marker, String fqcn, int level, String message, Object[] params, Throwable throwable) {
        SimpleMessage msg;
        Level log4jLevel = Log4jLogger.getLevel(level);
        org.apache.logging.log4j.Marker log4jMarker = Log4jLogger.getMarker(marker);
        ExtendedLogger logger = this.getLogger();
        if (!logger.isEnabled(log4jLevel, log4jMarker, message, params)) {
            return;
        }
        if (CONVERTER != null && this.eventLogger && marker != null && marker.contains(EVENT_MARKER)) {
            msg = CONVERTER.convertEvent(message, params, throwable);
        } else if (params == null) {
            msg = new SimpleMessage(message);
        } else {
            msg = new ParameterizedMessage(message, params, throwable);
            if (throwable != null) {
                throwable = msg.getThrowable();
            }
        }
        logger.logMessage(fqcn, log4jLevel, log4jMarker, (Message)msg, throwable);
    }

    private static org.apache.logging.log4j.Marker getMarker(Marker marker) {
        if (marker == null) {
            return null;
        }
        if (marker instanceof Log4jMarker) {
            return ((Log4jMarker)marker).getLog4jMarker();
        }
        Log4jMarkerFactory factory = (Log4jMarkerFactory)StaticMarkerBinder.SINGLETON.getMarkerFactory();
        return ((Log4jMarker)factory.getMarker(marker)).getLog4jMarker();
    }

    public String getName() {
        return this.name;
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }

    private static EventDataConverter createConverter() {
        try {
            LoaderUtil.loadClass((String)"org.slf4j.ext.EventData");
            return new EventDataConverter();
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private static Level getLevel(int i) {
        switch (i) {
            case 0: {
                return Level.TRACE;
            }
            case 10: {
                return Level.DEBUG;
            }
            case 20: {
                return Level.INFO;
            }
            case 30: {
                return Level.WARN;
            }
            case 40: {
                return Level.ERROR;
            }
        }
        return Level.ERROR;
    }

    private ExtendedLogger getLogger() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ExtendedLogger extendedLogger = this.loggerMap.get(classLoader);
        if (extendedLogger == null) {
            LoggerContext loggerContext = LOGGER_CONTEXT_MAP.get(classLoader);
            if (loggerContext == null) {
                loggerContext = LogManager.getContext((ClassLoader)classLoader, (boolean)false);
                LOGGER_CONTEXT_MAP.put(classLoader, loggerContext);
            }
            extendedLogger = loggerContext.getLogger(this.name);
            this.loggerMap.put(classLoader, extendedLogger);
        }
        return extendedLogger;
    }
}

