/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.koupleless.common.BizRuntimeContext;
import com.alipay.sofa.koupleless.common.exception.BizRuntimeException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.context.ApplicationContext;

public class BizRuntimeContextRegistry {
    private static ConcurrentHashMap<ClassLoader, BizRuntimeContext> contextMap = new ConcurrentHashMap();

    public static void registerBizRuntimeManager(BizRuntimeContext bizRuntimeContext) {
        contextMap.put(bizRuntimeContext.getAppClassLoader(), bizRuntimeContext);
    }

    public static void unRegisterBizRuntimeManager(BizRuntimeContext bizRuntimeContext) {
        contextMap.remove(bizRuntimeContext.getAppClassLoader());
    }

    public static void unRegisterBizRuntimeManager(ClassLoader classLoader) {
        contextMap.remove(classLoader);
    }

    public static Set<BizRuntimeContext> getRuntimeSet() {
        return Collections.unmodifiableSet(new CopyOnWriteArraySet<BizRuntimeContext>(contextMap.values()));
    }

    public static ConcurrentHashMap<ClassLoader, BizRuntimeContext> getRuntimeMap() {
        return contextMap;
    }

    public static BizRuntimeContext getBizRuntimeContext(Biz biz) {
        if (BizRuntimeContextRegistry.getRuntimeMap().containsKey(biz.getBizClassLoader())) {
            return BizRuntimeContextRegistry.getRuntimeMap().get(biz.getBizClassLoader());
        }
        throw new BizRuntimeException("100002", "No BizRuntimeContext found for biz: " + biz.getBizName());
    }

    public static BizRuntimeContext getMasterBizRuntimeContext() {
        Biz masterBiz = ArkClient.getMasterBiz();
        return BizRuntimeContextRegistry.getBizRuntimeContext(masterBiz);
    }

    public static BizRuntimeContext getBizRuntimeContextByClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new BizRuntimeException("100002", "Can't find BizRuntimeContext for null classLoader");
        }
        if (BizRuntimeContextRegistry.getRuntimeMap().containsKey(classLoader)) {
            return BizRuntimeContextRegistry.getRuntimeMap().get(classLoader);
        }
        throw new BizRuntimeException("100002", "No BizRuntimeContext found for classLoader: " + classLoader);
    }

    public static BizRuntimeContext getBizRuntimeContextByApplicationContext(ApplicationContext applicationContext) {
        for (BizRuntimeContext bizRuntimeContext : BizRuntimeContextRegistry.getRuntimeSet()) {
            if (bizRuntimeContext.getRootApplicationContext() == null || !bizRuntimeContext.getRootApplicationContext().equals(applicationContext)) continue;
            return bizRuntimeContext;
        }
        throw new BizRuntimeException("100002", "No BizRuntimeContext found for applicationContext: " + applicationContext);
    }
}

