/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.api;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.koupleless.common.service.ServiceProxyFactory;
import com.alipay.sofa.koupleless.common.util.ArkUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SpringServiceFinder {
    public static <T> T getBaseService(String name, Class<T> serviceType) {
        Biz masterBiz = ArkClient.getMasterBiz();
        return ServiceProxyFactory.createServiceProxy(masterBiz.getBizName(), masterBiz.getBizVersion(), name, serviceType, null);
    }

    public static <T> T getBaseService(Class<T> serviceType) {
        Biz masterBiz = ArkClient.getMasterBiz();
        return ServiceProxyFactory.createServiceProxy(masterBiz.getBizName(), masterBiz.getBizVersion(), null, serviceType, null);
    }

    public static <T> Map<String, T> listBaseServices(Class<T> serviceType) {
        Biz masterBiz = ArkClient.getMasterBiz();
        return ServiceProxyFactory.batchCreateServiceProxy(masterBiz.getBizName(), masterBiz.getBizVersion(), serviceType, null);
    }

    public static <T> T getModuleService(String bizName, String bizVersion, String name, Class<T> serviceType) {
        return ServiceProxyFactory.createServiceProxy(bizName, bizVersion, name, serviceType, null);
    }

    public static <T> Map<Biz, T> getModuleServices(String name, Class<T> serviceType) {
        return SpringServiceFinder.getActivatedModuleServices(name, serviceType);
    }

    protected static <T> Map<Biz, T> getActivatedModuleServices(String name, Class<T> serviceType) {
        Biz masterBiz = ArkClient.getMasterBiz();
        List bizList = ArkClient.getBizManagerService().getBizInOrder().stream().filter(biz -> biz != masterBiz && biz.getBizState().equals((Object)BizState.ACTIVATED)).collect(Collectors.toList());
        HashMap<Biz, T> bizMap = new HashMap<Biz, T>();
        for (Biz biz2 : bizList) {
            T proxy = ServiceProxyFactory.filterServiceProxy(biz2.getBizName(), biz2.getBizVersion(), name, serviceType, null);
            if (proxy == null) continue;
            bizMap.put(biz2, proxy);
        }
        return bizMap;
    }

    public static <T> T getModuleServiceWithoutVersion(String bizName, String serviceName, Class<T> serviceType) {
        return SpringServiceFinder.getActivatedModuleServiceWithoutVersion(bizName, serviceName, serviceType);
    }

    protected static <T> T getActivatedModuleServiceWithoutVersion(String bizName, String serviceName, Class<T> serviceType) {
        ArkUtils.checkBizExists(bizName);
        Biz biz = ArkClient.getBizManagerService().getActiveBiz(bizName);
        if (biz == null) {
            return null;
        }
        return ServiceProxyFactory.createServiceProxy(biz.getBizName(), biz.getBizVersion(), serviceName, serviceType, null);
    }

    public static <T> T getModuleService(String bizName, String bizVersion, Class<T> serviceType) {
        return ServiceProxyFactory.createServiceProxy(bizName, bizVersion, null, serviceType, null);
    }

    public static <T> Map<String, T> listModuleServices(String bizName, String bizVersion, Class<T> serviceType) {
        return ServiceProxyFactory.batchCreateServiceProxy(bizName, bizVersion, serviceType, null);
    }

    public static <T> Map<Biz, Map<String, T>> listAllModuleServices(Class<T> serviceType) {
        Biz masterBiz = ArkClient.getMasterBiz();
        List bizList = ArkClient.getBizManagerService().getBizInOrder().stream().filter(biz -> biz != masterBiz).collect(Collectors.toList());
        HashMap<Biz, Map<String, T>> bizMap = new HashMap<Biz, Map<String, T>>();
        for (Biz biz2 : bizList) {
            Map<String, T> proxies = ServiceProxyFactory.batchCreateServiceProxy(biz2.getBizName(), biz2.getBizVersion(), serviceType, null);
            bizMap.put(biz2, proxies);
        }
        return bizMap;
    }
}

