/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.model;

import com.alipay.sofa.koupleless.common.util.ClassUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MainApplicationContext {
    private Map<String, Object> objectMap = new ConcurrentHashMap<String, Object>();
    private Map<Class<?>, Map<String, Object>> typeMap = new ConcurrentHashMap();

    public Object getObject(String key) {
        return this.objectMap.get(key);
    }

    public <T> Map<String, T> getObjectMap(Class<T> type) {
        return ImmutableMap.copyOf((Map)this.typeMap.getOrDefault(type, new ConcurrentHashMap()));
    }

    public void register(Object obj) {
        this.doRegister(obj.getClass().getName(), obj);
    }

    public void register(String alias, Object obj) {
        this.doRegister(obj.getClass().getName(), obj);
        this.doRegister(alias, obj);
    }

    public void close() {
        this.objectMap.clear();
        this.typeMap.clear();
    }

    private void doRegister(String key, Object obj) {
        this.innerRegister(key, obj);
        this.innerRegister(obj.getClass(), key, obj);
        Class<?>[] interfaces = obj.getClass().getInterfaces();
        Arrays.stream(interfaces).forEach(i -> this.innerRegister((Class<?>)i, key, obj));
        ClassUtils.getSuperClasses(obj.getClass()).forEach(i -> this.innerRegister((Class<?>)i, key, obj));
    }

    private void innerRegister(String key, Object obj) {
        this.objectMap.put(key, obj);
    }

    private void innerRegister(Class<?> type, String key, Object obj) {
        Map map = this.typeMap.getOrDefault(type, new ConcurrentHashMap());
        map.put(key, obj);
        this.typeMap.put(type, map);
    }
}

