/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.service;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.koupleless.common.api.AutowiredFromBase;
import com.alipay.sofa.koupleless.common.api.AutowiredFromBiz;
import com.alipay.sofa.koupleless.common.service.ServiceProxyFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ArkAutowiredBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArkAutowiredBeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClassType = bean.getClass();
        ReflectionUtils.doWithFields(beanClassType, field -> {
            String name;
            String bizVersion;
            String bizName;
            LOGGER.info("Processing bean [{}] field [{}]", (Object)beanName, (Object)field);
            AutowiredFromBase autowiredFromBase = field.getAnnotation(AutowiredFromBase.class);
            AutowiredFromBiz autowiredFromBiz = field.getAnnotation(AutowiredFromBiz.class);
            if (autowiredFromBase != null) {
                Biz masterBiz = ArkClient.getMasterBiz();
                bizName = masterBiz.getBizName();
                bizVersion = masterBiz.getBizVersion();
                name = autowiredFromBase.name();
                boolean required = autowiredFromBase.required();
            } else if (autowiredFromBiz != null) {
                bizName = autowiredFromBiz.bizName();
                bizVersion = autowiredFromBiz.bizVersion();
                name = autowiredFromBiz.name();
                boolean required = autowiredFromBiz.required();
            } else {
                return;
            }
            ClassLoader clientClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object serviceProxy = null;
                Class<?> fieldType = field.getType();
                if (StringUtils.hasText((String)name)) {
                    serviceProxy = ServiceProxyFactory.createServiceProxy(bizName, bizVersion, name, fieldType, clientClassLoader);
                }
                if (serviceProxy == null && !Collection.class.isAssignableFrom(fieldType) && !Map.class.isAssignableFrom(fieldType)) {
                    serviceProxy = ServiceProxyFactory.createServiceProxy(bizName, bizVersion, null, fieldType, clientClassLoader);
                }
                if (serviceProxy == null) {
                    Type genericType = field.getGenericType();
                    ParameterizedType parameterizedType = (ParameterizedType)genericType;
                    Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                    Class serviceType = (Class)actualTypeArguments[0];
                    if (Map.class.isAssignableFrom(fieldType)) {
                        serviceType = (Class)actualTypeArguments[1];
                    }
                    Map serviceProxyMap = ServiceProxyFactory.batchCreateServiceProxy(bizName, bizVersion, serviceType, clientClassLoader);
                    if (Map.class.isAssignableFrom(fieldType)) {
                        serviceProxy = serviceProxyMap;
                    } else if (List.class.isAssignableFrom(fieldType)) {
                        List list = (List)ArrayList.class.newInstance();
                        list.addAll(serviceProxyMap.values());
                        serviceProxy = list;
                    } else if (Set.class.isAssignableFrom(fieldType)) {
                        Set set = (Set)HashSet.class.newInstance();
                        set.addAll(serviceProxyMap.values());
                        serviceProxy = set;
                    }
                }
                if (serviceProxy != null) {
                    ReflectionUtils.makeAccessible((Field)field);
                    ReflectionUtils.setField((Field)field, (Object)bean, serviceProxy);
                    LOGGER.info("Finished processing bean [{}], success to inject service proxy to bean [{}] field [{}]", new Object[]{beanName, bean, field});
                }
            }
            catch (Exception e) {
                throw new BeanCreationException(beanName, "Failed processing bean [" + beanName + "], injected object to bean [" + bean + "] field [" + field + "]", (Throwable)e);
            }
        }, field -> !Modifier.isStatic(field.getModifiers()) && (field.isAnnotationPresent(AutowiredFromBase.class) || field.isAnnotationPresent(AutowiredFromBiz.class)));
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

