/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.service;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.koupleless.common.BizRuntimeContext;
import com.alipay.sofa.koupleless.common.BizRuntimeContextRegistry;
import com.alipay.sofa.koupleless.common.exception.BizRuntimeException;
import com.alipay.sofa.koupleless.common.service.ServiceProxyCache;
import com.alipay.sofa.koupleless.common.service.SpringServiceInvoker;
import com.alipay.sofa.koupleless.common.util.ReflectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;

public class ServiceProxyFactory {
    public static <T> T createServiceProxy(String bizName, String bizVersion, String name, Class<T> clientType, ClassLoader clientClassLoader) {
        Object service = ServiceProxyFactory.getService(bizName, bizVersion, name, clientType);
        return ServiceProxyFactory.doCreateServiceProxy(bizName, bizVersion, service, name, clientType, clientClassLoader);
    }

    public static <T> Map<String, T> batchCreateServiceProxy(String bizName, String bizVersion, Class<T> serviceType, ClassLoader clientClassLoader) {
        Biz biz = ArkClient.getBizManagerService().getBiz(bizName, bizVersion);
        Class<?> serviceClass = ServiceProxyFactory.checkBizStateAndGetTargetClass(bizName, bizVersion, biz, serviceType);
        Map<String, ?> serviceMap = ServiceProxyFactory.listService(biz, serviceClass);
        HashMap<String, T> proxyMap = new HashMap<String, T>();
        for (String beanName : serviceMap.keySet()) {
            proxyMap.put(beanName, ServiceProxyFactory.doCreateServiceProxy(biz.getBizName(), biz.getBizVersion(), serviceMap.get(beanName), null, serviceType, clientClassLoader));
        }
        return proxyMap;
    }

    public static <T> T filterServiceProxy(String bizName, String bizVersion, String name, Class<T> serviceType, ClassLoader clientClassLoader) {
        Biz biz = ArkClient.getBizManagerService().getBiz(bizName, bizVersion);
        Class<?> serviceClass = ServiceProxyFactory.tryToGetTargetClass(bizName, bizVersion, biz, serviceType);
        if (null == serviceClass) {
            return null;
        }
        Map<String, ?> serviceMap = ServiceProxyFactory.listService(biz, serviceClass);
        if (serviceMap.containsKey(name)) {
            return ServiceProxyFactory.doCreateServiceProxy(biz.getBizName(), biz.getBizVersion(), serviceMap.get(name), null, serviceType, clientClassLoader);
        }
        return null;
    }

    public static Object getService(String bizName, String bizVersion, String name, Class<?> clientType) {
        Biz biz = ServiceProxyFactory.determineMostSuitableBiz(bizName, bizVersion);
        if (biz == null || biz.getBizState() == BizState.RESOLVED) {
            return null;
        }
        if (biz.getBizState() != BizState.ACTIVATED && biz.getBizState() != BizState.DEACTIVATED) {
            throw new BizRuntimeException("100004", String.format("biz %s:%s state %s is not valid", bizName, bizVersion, biz.getBizState()));
        }
        BizRuntimeContext bizRuntimeContext = BizRuntimeContextRegistry.getBizRuntimeContext(biz);
        if (bizRuntimeContext.getApplicationContext() == null || bizRuntimeContext.getApplicationContext().get() == null) {
            throw new BizRuntimeException("100002", String.format("biz %s:%s application context is null", bizName, bizVersion));
        }
        if (!StringUtils.isEmpty((String)name)) {
            return bizRuntimeContext.getApplicationContext().getObject(name);
        }
        if (clientType != null) {
            Class<?> serviceType;
            try {
                serviceType = biz.getBizClassLoader().loadClass(clientType.getName());
            }
            catch (ClassNotFoundException e) {
                throw new BizRuntimeException("100005", String.format("Cannot find class %s from the biz %s", clientType.getName(), biz.getIdentity()));
            }
            return bizRuntimeContext.getApplicationContext().getObject(serviceType);
        }
        throw new BizRuntimeException("100002", "invalid config");
    }

    private static <T> Map<String, T> listService(Biz biz, Class<T> serviceType) {
        BizRuntimeContext bizRuntimeContext = ServiceProxyFactory.checkBizStateAndGetBizRuntimeContext(biz.getBizName(), biz.getBizVersion(), biz);
        return bizRuntimeContext.getApplicationContext().getObjectsOfType(serviceType);
    }

    private static <T> T doCreateServiceProxy(String bizName, String bizVersion, Object service, String name, Class<T> clientType, ClassLoader clientClassLoader) {
        if (clientClassLoader == null) {
            Class<?> callerClass = ReflectionUtils.getCallerClass(6);
            clientClassLoader = callerClass.getClassLoader();
        }
        BizRuntimeContext bizRuntimeContext = BizRuntimeContextRegistry.getBizRuntimeContextByClassLoader(clientClassLoader);
        Map<ClassLoader, Map<String, ServiceProxyCache>> serviceProxyCaches = bizRuntimeContext.getServiceProxyCaches();
        Biz biz = ServiceProxyFactory.determineMostSuitableBiz(bizName, bizVersion);
        if (biz != null) {
            String cacheKey;
            Map cacheMap = serviceProxyCaches.computeIfAbsent(biz.getBizClassLoader(), o -> new ConcurrentHashMap());
            String string = cacheKey = service != null ? service.getClass().getName() : clientType.getName();
            if (cacheMap.containsKey(cacheKey)) {
                ServiceProxyCache serviceProxyCache = (ServiceProxyCache)cacheMap.get(cacheKey);
                return (T)serviceProxyCache.getProxy();
            }
        }
        SpringServiceInvoker serviceInvoker = new SpringServiceInvoker(service, name, clientType, bizName, bizVersion, clientClassLoader, service != null ? service.getClass().getClassLoader() : null);
        ProxyFactory factory = new ProxyFactory();
        if (clientType.isInterface()) {
            factory.addInterface(clientType);
        } else {
            factory.setTargetClass(clientType);
            factory.setProxyTargetClass(true);
        }
        factory.addAdvice((Advice)serviceInvoker);
        Object proxy = factory.getProxy(clientClassLoader);
        if (biz != null) {
            String cacheKey = service != null ? service.getClass().getName() : clientType.getName();
            Map cacheMap = serviceProxyCaches.computeIfAbsent(biz.getBizClassLoader(), o -> new ConcurrentHashMap());
            cacheMap.put(cacheKey, new ServiceProxyCache(proxy, serviceInvoker));
        }
        return (T)proxy;
    }

    public static Biz determineMostSuitableBiz(String bizName, String bizVersion) {
        Biz biz;
        if (StringUtils.isEmpty((String)bizVersion)) {
            List bizList = ArkClient.getBizManagerService().getBiz(bizName);
            if (bizList.size() == 0) {
                return null;
            }
            biz = bizList.stream().filter(it -> BizState.ACTIVATED == it.getBizState()).findFirst().orElse(null);
        } else {
            biz = ArkClient.getBizManagerService().getBiz(bizName, bizVersion);
        }
        return biz;
    }

    private static Class<?> checkBizStateAndGetTargetClass(String bizName, String bizVersion, Biz biz, Class<?> sourceClass) {
        ServiceProxyFactory.checkBizState(bizName, bizVersion, biz);
        try {
            return biz.getBizClassLoader().loadClass(sourceClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new BizRuntimeException("100005", "Cannot find class " + sourceClass.getName() + " from the biz " + biz.getIdentity());
        }
    }

    private static Class<?> tryToGetTargetClass(String bizName, String bizVersion, Biz biz, Class<?> sourceClass) {
        ServiceProxyFactory.checkBizState(bizName, bizVersion, biz);
        try {
            return biz.getBizClassLoader().loadClass(sourceClass.getName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static BizRuntimeContext checkBizStateAndGetBizRuntimeContext(String bizName, String bizVersion, Biz biz) {
        ServiceProxyFactory.checkBizState(bizName, bizVersion, biz);
        BizRuntimeContext bizRuntimeContext = BizRuntimeContextRegistry.getBizRuntimeContext(biz);
        if (bizRuntimeContext == null) {
            throw new BizRuntimeException("100002", "biz runtime context is null");
        }
        if (bizRuntimeContext.getApplicationContext() == null || bizRuntimeContext.getApplicationContext().get() == null) {
            throw new BizRuntimeException("100002", "biz application context is null");
        }
        return bizRuntimeContext;
    }

    private static void checkBizState(String bizName, String bizVersion, Biz biz) {
        if (biz == null) {
            throw new BizRuntimeException("100003", String.format("biz %s:%s does not exist", bizName, bizVersion));
        }
        if (biz.getBizState() != BizState.ACTIVATED && biz.getBizState() != BizState.DEACTIVATED) {
            throw new BizRuntimeException("100004", String.format("biz %s:%s state %s is not valid", bizName, bizVersion, biz.getBizState()));
        }
    }
}

