/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.util;

import com.alipay.sofa.koupleless.common.util.UnsafeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class IsolatedEnvironment
extends AbstractMap<String, String> {
    private static final String BIZ_CLASS_LOADER = "com.alipay.sofa.ark.container.service.classloader.BizClassLoader";
    private static final String EMPTY = "";
    private static Method GET_BIZ_MODEL_METHOD;
    private static Method GET_BIZ_NAME;
    private final String bizClassLoaderName;
    private final Map<String, String> original;
    private final Map<String, String> additional;
    private final Set<String> keys;
    private final Map<ClassLoader, String> cache = new ConcurrentHashMap<ClassLoader, String>();

    private IsolatedEnvironment(String bizClassLoaderName, Map<String, String> original, Map<String, String> additional, Set<String> keys) {
        this.bizClassLoaderName = bizClassLoaderName;
        this.original = original;
        this.additional = additional;
        this.keys = keys;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean containsKey(Object key) {
        String prefix = this.getKeyPrefix();
        return !EMPTY.equals(prefix) && this.keys.contains(prefix + key) || this.keys.contains(key);
    }

    @Override
    public String get(Object key) {
        String value;
        String prefix = this.getKeyPrefix();
        if (!this.additional.isEmpty() && (value = IsolatedEnvironment.get(this.additional, prefix, key)) != null) {
            return value;
        }
        return IsolatedEnvironment.get(this.original, prefix, key);
    }

    private static String get(Map<String, String> map, String prefix, Object key) {
        String value;
        if (!EMPTY.equals(prefix) && (value = map.get(prefix + key)) != null) {
            return value;
        }
        return map.get(key);
    }

    private String getKeyPrefix() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? EMPTY : this.cache.computeIfAbsent(tccl, this::readKeyPrefix);
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                final Iterator it = IsolatedEnvironment.this.keys.iterator();
                return new Iterator<Map.Entry<String, String>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        final String key = (String)it.next();
                        return new Map.Entry<String, String>(){

                            @Override
                            public String getKey() {
                                return key;
                            }

                            @Override
                            public String getValue() {
                                return IsolatedEnvironment.this.get(key);
                            }

                            @Override
                            public String setValue(String value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return IsolatedEnvironment.this.keys.size();
            }
        };
    }

    public static Map<String, String> takeover(String bizClassLoaderName, Map<String, String> additionalEnv) {
        Objects.requireNonNull(bizClassLoaderName, "bizClassLoaderName");
        Objects.requireNonNull(additionalEnv, "additionalEnv");
        try {
            Set<String> unmodifiableKeys;
            Class<?> envClass = Class.forName("java.lang.ProcessEnvironment");
            Field unmodifiableField = envClass.getDeclaredField("theUnmodifiableEnvironment");
            Map unmodifiableEnv = (Map)UnsafeUtils.readStaticField(envClass, unmodifiableField);
            if (unmodifiableEnv instanceof IsolatedEnvironment) {
                return ((IsolatedEnvironment)unmodifiableEnv).original;
            }
            if (additionalEnv.isEmpty()) {
                unmodifiableKeys = unmodifiableEnv.keySet();
            } else {
                unmodifiableKeys = new HashSet(unmodifiableEnv.size() + additionalEnv.size());
                unmodifiableKeys.addAll(unmodifiableEnv.keySet());
                unmodifiableKeys.addAll(additionalEnv.keySet());
            }
            IsolatedEnvironment unmodifiableEnvWrapper = new IsolatedEnvironment(bizClassLoaderName, unmodifiableEnv, additionalEnv, unmodifiableKeys);
            UnsafeUtils.writeStaticField(envClass, unmodifiableField, unmodifiableEnvWrapper);
            try {
                Map<String, String> caseInsensitiveAdditionalEnv;
                Set<String> caseInsensitiveKeys;
                Field caseInsensitiveField = envClass.getDeclaredField("theCaseInsensitiveEnvironment");
                Map caseInsensitiveEnv = (Map)UnsafeUtils.readStaticField(envClass, caseInsensitiveField);
                if (additionalEnv.isEmpty()) {
                    caseInsensitiveKeys = caseInsensitiveEnv.keySet();
                    caseInsensitiveAdditionalEnv = additionalEnv;
                } else {
                    caseInsensitiveKeys = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    caseInsensitiveKeys.addAll(caseInsensitiveEnv.keySet());
                    caseInsensitiveKeys.addAll(additionalEnv.keySet());
                    caseInsensitiveAdditionalEnv = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                    caseInsensitiveAdditionalEnv.putAll(additionalEnv);
                }
                IsolatedEnvironment caseInsensitiveEnvWrapper = new IsolatedEnvironment(bizClassLoaderName, caseInsensitiveEnv, caseInsensitiveAdditionalEnv, caseInsensitiveKeys);
                UnsafeUtils.writeStaticField(envClass, caseInsensitiveField, caseInsensitiveEnvWrapper);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return unmodifiableEnv;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize isolated environment", e);
        }
    }

    public static Map<String, String> takeover(Map<String, String> additionalEnv) {
        return IsolatedEnvironment.takeover(BIZ_CLASS_LOADER, additionalEnv);
    }

    public static Map<String, String> takeover(String bizClassLoaderName) {
        return IsolatedEnvironment.takeover(bizClassLoaderName, Collections.emptyMap());
    }

    public static Map<String, String> takeover() {
        return IsolatedEnvironment.takeover(BIZ_CLASS_LOADER, Collections.emptyMap());
    }

    protected String readKeyPrefix(ClassLoader classLoader) {
        while (classLoader != null && !this.isBizClassLoader(classLoader.getClass())) {
            classLoader = classLoader.getParent();
        }
        if (classLoader != null) {
            try {
                Object bizModel;
                if (GET_BIZ_MODEL_METHOD == null) {
                    GET_BIZ_MODEL_METHOD = classLoader.getClass().getMethod("getBizModel", new Class[0]);
                }
                if ((bizModel = GET_BIZ_MODEL_METHOD.invoke((Object)classLoader, new Object[0])) != null) {
                    String value;
                    if (GET_BIZ_NAME == null) {
                        GET_BIZ_NAME = bizModel.getClass().getMethod("getBizName", new Class[0]);
                    }
                    if ((value = (String)GET_BIZ_NAME.invoke(bizModel, new Object[0])) != null) {
                        return value.replaceAll("[-.]", "_") + '_';
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return EMPTY;
    }

    private boolean isBizClassLoader(Class<?> clazz) {
        while (clazz != null && ClassLoader.class.isAssignableFrom(clazz)) {
            if (this.bizClassLoaderName.equals(clazz.getName())) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

