/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.util;

import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MultiBizProperties
extends Properties {
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private final String bizClassLoaderName;
    private static final String BIZ_CLASS_LOADER = "com.alipay.sofa.ark.container.service.classloader.BizClassLoader";
    private Map<ClassLoader, Set<String>> modifiedKeysMap = new HashMap<ClassLoader, Set<String>>();
    private final Properties baseProperties;
    private Map<ClassLoader, Properties> bizPropertiesMap = new HashMap<ClassLoader, Properties>();

    private MultiBizProperties(String bizClassLoaderName, Properties baseProperties) {
        this.baseProperties = baseProperties;
        this.bizClassLoaderName = bizClassLoaderName;
    }

    public MultiBizProperties(String bizClassLoaderName) {
        this(bizClassLoaderName, new Properties());
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        this.addModifiedKey(key);
        return this.getWriteProperties().setProperty(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.getReadProperties().getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getReadProperties().getProperty(key, defaultValue);
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        this.getWriteProperties().putAll((Map<?, ?>)properties);
        this.addModifiedKeys(properties.stringPropertyNames());
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inStream);
        this.getWriteProperties().putAll((Map<?, ?>)properties);
        this.addModifiedKeys(properties.stringPropertyNames());
    }

    @Override
    public void list(PrintStream out) {
        this.getWriteProperties().list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.getWriteProperties().list(out);
    }

    @Override
    public void save(OutputStream out, String comments) {
        Properties properties = this.getWriteProperties();
        properties.save(out, comments);
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        Properties properties = this.getReadProperties();
        properties.store(writer, comments);
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        Properties properties = this.getReadProperties();
        properties.store(out, comments);
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.loadFromXML(in);
        this.getWriteProperties().putAll((Map<?, ?>)properties);
        this.addModifiedKeys(properties.stringPropertyNames());
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        Properties properties = this.getReadProperties();
        properties.storeToXML(os, comment);
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        Properties properties = this.getReadProperties();
        properties.storeToXML(os, comment, encoding);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.getReadProperties().propertyNames();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.getReadProperties().stringPropertyNames();
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        boolean success = this.getWriteProperties().remove(key, value);
        if (success) {
            this.addModifiedKey(key.toString());
        }
        return success;
    }

    @Override
    public synchronized Object get(Object key) {
        return this.getReadProperties().get(key);
    }

    @Override
    public synchronized Object remove(Object key) {
        if (key != null) {
            this.addModifiedKey(key.toString());
        }
        return this.getWriteProperties().remove(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        String text = key == null ? null : key.toString();
        this.addModifiedKey(text);
        return this.getWriteProperties().put(key, value);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.getReadProperties().equals(o);
    }

    @Override
    public synchronized String toString() {
        return this.getReadProperties().toString();
    }

    @Override
    public Collection<Object> values() {
        return this.getReadProperties().values();
    }

    @Override
    public synchronized int hashCode() {
        return this.getReadProperties().hashCode();
    }

    @Override
    public synchronized void clear() {
        Set<String> keys = this.baseProperties.stringPropertyNames();
        this.getWriteProperties().clear();
        this.addModifiedKeys(keys);
    }

    @Override
    public synchronized Object clone() {
        MultiBizProperties mbp = new MultiBizProperties(this.bizClassLoaderName, this.baseProperties);
        mbp.bizPropertiesMap = new HashMap<ClassLoader, Properties>();
        this.bizPropertiesMap.forEach((? super K k, ? super V p) -> mbp.bizPropertiesMap.put((ClassLoader)k, (Properties)p.clone()));
        mbp.bizPropertiesMap.putAll(this.bizPropertiesMap);
        mbp.modifiedKeysMap = new HashMap<ClassLoader, Set<String>>();
        this.modifiedKeysMap.forEach((? super K k, ? super V s) -> {
            Set cfr_ignored_0 = mbp.modifiedKeysMap.put((ClassLoader)k, new HashSet(s));
        });
        return mbp;
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        Object curValue = this.get(key);
        if (!Objects.equals(curValue, oldValue) || curValue == null && !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.getReadProperties().isEmpty();
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        Object curValue = this.get(key);
        if (curValue != null || this.containsKey(key)) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.getReadProperties().containsKey(key);
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.getReadProperties().contains(value);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            v = function.apply(k, v);
            map.put(k, v);
        }
        this.putAll(map);
    }

    @Override
    public synchronized int size() {
        return this.getReadProperties().size();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.getReadProperties().entrySet();
    }

    @Override
    public synchronized void putAll(Map map) {
        HashSet<String> keys = new HashSet<String>();
        for (Object key : map.keySet()) {
            String text = key == null ? null : key.toString();
            keys.add(text);
        }
        this.addModifiedKeys(keys);
        this.getWriteProperties().putAll((Map<?, ?>)map);
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
        Object newValue;
        Object value = this.get(key);
        if (value == null && (newValue = mappingFunction.apply(key)) != null) {
            this.put(key, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        return this.getReadProperties().elements();
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.getReadProperties().forEach(action);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        Object v = this.get(key);
        if (v == null) {
            v = this.put(key, value);
        }
        return v;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return this.getReadProperties().keys();
    }

    @Override
    public Set<Object> keySet() {
        return this.getReadProperties().keySet();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getReadProperties().containsValue(value);
    }

    @Override
    public synchronized Object getOrDefault(Object key, Object defaultValue) {
        return this.getReadProperties().getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        Object oldValue = this.get(key);
        if (oldValue == null) {
            return null;
        }
        Object newValue = remappingFunction.apply(key, oldValue);
        if (newValue != null) {
            this.put(key, newValue);
            return newValue;
        }
        this.remove(key);
        return null;
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        Object oldValue = this.get(key);
        Object newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            if (oldValue != null || this.containsKey(key)) {
                this.remove(key);
            }
            return null;
        }
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        Object newValue;
        Object oldValue = this.get(key);
        Object object = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        if (newValue == null) {
            this.remove(key);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }

    public ClassLoader getBizClassLoader() {
        ClassLoader invokeClassLoader = Thread.currentThread().getContextClassLoader();
        return this.getBizClassLoader(invokeClassLoader);
    }

    private synchronized Properties getReadProperties() {
        Properties bizProperties = this.getWriteProperties();
        if (bizProperties == this.baseProperties) {
            return this.baseProperties;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.baseProperties);
        Set<String> modifiedKeys = this.getModifiedKeys();
        if (modifiedKeys != null) {
            modifiedKeys.forEach(properties::remove);
        }
        properties.putAll((Map<?, ?>)bizProperties);
        return properties;
    }

    private ClassLoader getBizClassLoader(ClassLoader invokeClassLoader) {
        for (ClassLoader classLoader = invokeClassLoader; classLoader != null; classLoader = classLoader.getParent()) {
            Class<?> clazz = classLoader.getClass();
            if (!this.isBizClassLoader(clazz)) continue;
            return classLoader;
        }
        return null;
    }

    private boolean isBizClassLoader(Class clazz) {
        if (!ClassLoader.class.isAssignableFrom(clazz)) {
            return false;
        }
        String name = clazz.getName();
        if (Objects.equals(name, this.bizClassLoaderName)) {
            return true;
        }
        return this.isBizClassLoader(clazz.getSuperclass());
    }

    private synchronized Properties getWriteProperties() {
        ClassLoader invokeClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.bizPropertiesMap.containsKey(invokeClassLoader)) {
            return this.bizPropertiesMap.get(invokeClassLoader);
        }
        ClassLoader classLoader = this.getBizClassLoader(invokeClassLoader);
        Properties props = classLoader != null ? this.bizPropertiesMap.computeIfAbsent(classLoader, (? super K k) -> new Properties()) : this.baseProperties;
        this.bizPropertiesMap.put(invokeClassLoader, props);
        return props;
    }

    private synchronized Set<String> getModifiedKeys() {
        ClassLoader invokeClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.modifiedKeysMap.containsKey(invokeClassLoader)) {
            return this.modifiedKeysMap.get(invokeClassLoader);
        }
        ClassLoader classLoader = this.getBizClassLoader(invokeClassLoader);
        if (classLoader != null) {
            Set keys = this.modifiedKeysMap.computeIfAbsent(classLoader, (? super K k) -> new HashSet());
            this.modifiedKeysMap.put(invokeClassLoader, keys);
            return keys;
        }
        return null;
    }

    private void addModifiedKey(String key) {
        this.addModifiedKeys(Collections.singleton(key));
    }

    private void addModifiedKeys(Collection<String> keys) {
        Set<String> modifiedKeys = this.getModifiedKeys();
        if (modifiedKeys != null && keys != null) {
            modifiedKeys.addAll(keys);
        }
    }

    private static MultiBizProperties initSystem(String bizClassLoaderName) {
        if (inited.compareAndSet(false, true)) {
            MultiBizProperties multiBizProperties;
            Properties properties = System.getProperties();
            if (properties instanceof MultiBizProperties) {
                multiBizProperties = (MultiBizProperties)properties;
                if (Objects.equals(multiBizProperties.bizClassLoaderName, bizClassLoaderName)) {
                    return multiBizProperties;
                }
            }
            multiBizProperties = new MultiBizProperties(bizClassLoaderName, properties);
            System.setProperties(multiBizProperties);
            return multiBizProperties;
        }
        ArkLoggerFactory.getDefaultLogger().info("MultiBizProperties had already initialized.");
        return (MultiBizProperties)System.getProperties();
    }

    public static MultiBizProperties initSystem() {
        return MultiBizProperties.initSystem(BIZ_CLASS_LOADER);
    }
}

