/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.util;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;

public class SerializeUtils {
    private static Object _serializeTransform(Object source, ClassLoader targetClassLoader) {
        Object target;
        try {
            if (source == null) {
                return source;
            }
            Class<?> sourceClass = source.getClass().equals(Class.class) ? (Class<?>)source : source.getClass();
            if (sourceClass.getClassLoader() == targetClassLoader || targetClassLoader.loadClass(sourceClass.getName()).getClassLoader() == sourceClass.getClassLoader()) {
                return source;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ClassLoader currentContextClassloader = Thread.currentThread().getContextClassLoader();
        try {
            if (targetClassLoader != null) {
                Thread.currentThread().setContextClassLoader(targetClassLoader);
            }
            SerializerFactory serializerFactory = new SerializerFactory();
            serializerFactory.setAllowNonSerializable(true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Hessian2Output h2o = new Hessian2Output((OutputStream)bos);
            h2o.setSerializerFactory(serializerFactory);
            h2o.writeObject(source);
            h2o.flush();
            byte[] content = bos.toByteArray();
            Hessian2Input h2i = new Hessian2Input((InputStream)new ByteArrayInputStream(content));
            h2i.setSerializerFactory(serializerFactory);
            target = h2i.readObject();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassloader);
        }
        return target;
    }

    public static Object serializeTransform(Object originalSource, ClassLoader targetClassLoader) {
        if (originalSource == null) {
            return null;
        }
        if (originalSource.getClass().isArray()) {
            Object[] sources = (Object[])originalSource;
            if (sources.length > 0) {
                Object[] targets = (Object[])Array.newInstance(sources.getClass().getComponentType(), sources.length);
                for (int i = 0; i < sources.length; ++i) {
                    targets[i] = SerializeUtils._serializeTransform(sources[i], targetClassLoader);
                }
                return targets;
            }
            return originalSource;
        }
        return SerializeUtils._serializeTransform(originalSource, targetClassLoader);
    }
}

