/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common;

import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.koupleless.common.exception.BizRuntimeException;
import com.alipay.sofa.koupleless.common.model.ApplicationContextHolder;
import com.alipay.sofa.koupleless.common.model.SpringApplicationContextHolder;
import com.alipay.sofa.koupleless.common.service.AbstractComponent;
import com.alipay.sofa.koupleless.common.service.AbstractServiceComponent;
import com.alipay.sofa.koupleless.common.service.BeanRegistry;
import com.alipay.sofa.koupleless.common.service.ComponentRegistry;
import com.alipay.sofa.koupleless.common.service.ServiceProxyCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;

public class BizRuntimeContext
implements ComponentRegistry {
    private String bizName;
    private ClassLoader appClassLoader;
    private ApplicationContextHolder applicationContext;
    private Map<ClassLoader, Map<String, ServiceProxyCache>> serviceProxyCaches = new ConcurrentHashMap<ClassLoader, Map<String, ServiceProxyCache>>();
    private Map<String, BeanRegistry<AbstractServiceComponent>> serviceMap = new ConcurrentHashMap<String, BeanRegistry<AbstractServiceComponent>>();

    public String getBizName() {
        return this.bizName;
    }

    public void setBizName(String bizName) {
        this.bizName = bizName;
    }

    public ClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    public void setAppClassLoader(ClassLoader appClassLoader) {
        this.appClassLoader = appClassLoader;
    }

    @Deprecated
    public ApplicationContext getRootApplicationContext() {
        if (this.applicationContext == null) {
            return null;
        }
        if (this.applicationContext.get() instanceof ApplicationContext) {
            return (ApplicationContext)this.applicationContext.get();
        }
        return null;
    }

    public ApplicationContextHolder getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContextHolder applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Deprecated
    public void setRootApplicationContext(ApplicationContext rootApplicationContext) {
        this.applicationContext = new SpringApplicationContextHolder(rootApplicationContext);
    }

    public BizRuntimeContext(Biz biz) {
        this(biz, null);
    }

    public BizRuntimeContext(Biz biz, ApplicationContext applicationContext) {
        this.bizName = biz.getBizName();
        this.appClassLoader = biz.getBizClassLoader();
        if (applicationContext != null) {
            this.applicationContext = new SpringApplicationContextHolder(applicationContext);
        }
    }

    public Map<ClassLoader, Map<String, ServiceProxyCache>> getServiceProxyCaches() {
        return this.serviceProxyCaches;
    }

    public void removeServiceProxyCaches(ClassLoader classLoader) {
        this.serviceProxyCaches.remove(classLoader);
    }

    public void shutdownContext() {
        try {
            if (null != this.applicationContext) {
                this.applicationContext.close();
            }
            this.appClassLoader = null;
        }
        catch (Throwable throwable) {
            throw new BizRuntimeException("100001", throwable);
        }
    }

    public void registerService(AbstractServiceComponent bean) {
        bean.setBizRuntimeContext(this);
        this.serviceMap.putIfAbsent(bean.getProtocol(), new BeanRegistry());
        this.doRegister(this.serviceMap.get(bean.getProtocol()), bean);
    }

    private void doRegister(BeanRegistry registry, AbstractComponent bean) {
        registry.register(bean.getIdentifier(), bean);
    }

    public void unregisterService(AbstractServiceComponent bean) {
        BeanRegistry<AbstractServiceComponent> registry = this.serviceMap.get(bean.getProtocol());
        if (null == registry) {
            throw new BizRuntimeException("200002", "protocol service" + bean.getProtocol() + " has not registered");
        }
        registry.unRegister(bean.getIdentifier());
    }

    @Override
    public <T extends AbstractServiceComponent> T getServiceComponent(String protocol, String identifier) {
        if (this.serviceMap.get(protocol) == null) {
            return null;
        }
        AbstractComponent serviceComponent = this.serviceMap.get(protocol).getBean(identifier);
        return (T)(serviceComponent == null ? null : (AbstractServiceComponent)serviceComponent);
    }
}

