/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.service;

import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.koupleless.common.exception.BizRuntimeException;
import com.alipay.sofa.koupleless.common.service.ServiceProxyFactory;
import com.alipay.sofa.koupleless.common.util.SerializeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringServiceInvoker
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringServiceInvoker.class);
    private static final String TOSTRING_METHOD = "toString";
    private static final String EQUALS_METHOD = "equals";
    private static final String HASHCODE_METHOD = "hashCode";
    private Object target;
    private String name;
    private Class<?> clientType;
    private String bizName;
    private String bizVersion;
    private ClassLoader clientClassLoader;
    private ClassLoader serviceClassLoader;

    public SpringServiceInvoker() {
    }

    public SpringServiceInvoker(Object target, String name, Class<?> clientType, String bizName, String bizVersion, ClassLoader clientClassLoader, ClassLoader serviceClassLoader) {
        this.target = target;
        this.name = name;
        this.clientType = clientType;
        this.bizName = bizName;
        this.bizVersion = bizVersion;
        this.clientClassLoader = clientClassLoader;
        this.serviceClassLoader = serviceClassLoader;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Biz biz = ServiceProxyFactory.determineMostSuitableBiz(this.bizName, this.bizVersion);
        if (biz == null) {
            throw new BizRuntimeException("100003", String.format("biz %s:%s does not exist when called", this.bizName, this.bizVersion));
        }
        if (biz.getBizState() == BizState.RESOLVED) {
            throw new BizRuntimeException("100003", String.format("biz %s:%s is still installing when called", this.bizName, this.bizVersion));
        }
        if (BizState.ACTIVATED != biz.getBizState() && BizState.DEACTIVATED != biz.getBizState()) {
            throw new BizRuntimeException("100004", String.format("biz %s:%s state %s is not valid", this.bizName, this.bizVersion, biz.getBizState()));
        }
        if (this.target == null) {
            this.target = ServiceProxyFactory.getService(this.bizName, this.bizVersion, this.name, this.clientType);
            if (this.target == null) {
                throw new BizRuntimeException("100004", "Cannot find service bean from the biz " + biz.getIdentity());
            }
            this.serviceClassLoader = this.target.getClass().getClassLoader();
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        long startTime = System.currentTimeMillis();
        try {
            Thread.currentThread().setContextClassLoader(this.serviceClassLoader);
            Object object = this.doInvoke(invocation);
            return object;
        }
        catch (Throwable e) {
            this.doCatch(invocation, e, startTime);
            throw e;
        }
        finally {
            this.doFinally(invocation, startTime);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected Object doInvoke(MethodInvocation invocation) throws InvocationTargetException, IllegalAccessException {
        if (this.isCrossClassLoader(invocation)) {
            return this.invokeServiceCrossClassLoader(invocation);
        }
        return this.invokeService(invocation);
    }

    protected void doCatch(MethodInvocation invocation, Throwable e, long startTime) {
    }

    protected void doFinally(MethodInvocation invocation, long startTime) {
    }

    private boolean isCrossClassLoader(MethodInvocation invocation) {
        return this.target.getClass().getClassLoader() != invocation.getMethod().getDeclaringClass().getClassLoader();
    }

    private Object invokeServiceCrossClassLoader(MethodInvocation invocation) throws InvocationTargetException, IllegalAccessException {
        Method clientMethod = invocation.getMethod();
        Object[] clientMethodArguments = invocation.getArguments();
        Class<?>[] clientMethodArgumentTypes = clientMethod.getParameterTypes();
        if (TOSTRING_METHOD.equalsIgnoreCase(clientMethod.getName()) && clientMethodArgumentTypes.length == 0) {
            return this.target.toString();
        }
        if (EQUALS_METHOD.equalsIgnoreCase(clientMethod.getName()) && clientMethodArgumentTypes.length == 1) {
            return this.target.equals(clientMethodArguments[0]);
        }
        if (HASHCODE_METHOD.equalsIgnoreCase(clientMethod.getName()) && clientMethodArgumentTypes.length == 0) {
            return this.target.hashCode();
        }
        Object[] serviceMethodArguments = (Object[])SerializeUtils.serializeTransform(clientMethodArguments, this.serviceClassLoader);
        Class[] serviceMethodArgumentTypes = (Class[])SerializeUtils.serializeTransform(clientMethodArgumentTypes, this.serviceClassLoader);
        Method serviceMethod = this.getTargetMethod(clientMethod, serviceMethodArgumentTypes);
        Object retVal = serviceMethod.invoke(this.target, serviceMethodArguments);
        return SerializeUtils.serializeTransform(retVal, this.clientClassLoader);
    }

    private Object invokeService(MethodInvocation invocation) throws InvocationTargetException, IllegalAccessException {
        Method method = invocation.getMethod();
        method.setAccessible(true);
        return method.invoke(this.target, invocation.getArguments());
    }

    private Method getTargetMethod(Method method, Class<?>[] argumentTypes) {
        try {
            return this.target.getClass().getMethod(method.getName(), argumentTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(this.target + " in " + this.bizName + ":" + this.bizVersion + " don't have the method " + method);
        }
    }
}

