/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.util;

public final class LoaderUtil {
    private LoaderUtil() {
    }

    public static ClassLoader getThreadContextClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        ClassLoader ccl = LoaderUtil.class.getClassLoader();
        return ccl == null ? ClassLoader.getSystemClassLoader() : ccl;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return LoaderUtil.getThreadContextClassLoader().loadClass(className);
        }
        catch (Throwable ignored) {
            return Class.forName(className);
        }
    }
}

