/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.util;

import com.alipay.sofa.ark.common.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.core.env.Environment;

public class PropertiesUtil {
    public static Properties loadProperties(ClassLoader classLoader, String resource) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = classLoader.getResourceAsStream(resource);
            if (inputStream != null) {
                properties.load(inputStream);
            }
            return properties;
        }
        catch (IOException e) {
            return properties;
        }
    }

    private static Set<String> formatPropertyValues(String value) {
        return StringUtils.strToSet((String)value, (String)",");
    }

    public static Set<String> formatPropertyValues(Environment environment, String key) {
        String value = environment.getProperty(key);
        if (!StringUtils.isEmpty((String)value)) {
            return PropertiesUtil.formatPropertyValues(value);
        }
        int i = 0;
        String value_with_index = environment.getProperty(key + "[" + i + "]");
        HashSet<String> values = new HashSet<String>();
        while (!StringUtils.isEmpty((String)value_with_index)) {
            values.addAll(PropertiesUtil.formatPropertyValues(value_with_index));
            value_with_index = environment.getProperty(key + "[" + ++i + "]");
        }
        return values;
    }
}

