/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.common.util;

import java.lang.reflect.Field;
import java.util.Objects;
import sun.misc.Unsafe;

public final class UnsafeUtils {
    public static final Unsafe UNSAFE;

    private UnsafeUtils() {
    }

    public static <T> T readStaticField(Class<?> cls, Field field) {
        Objects.requireNonNull(UNSAFE, "Unsafe initialization failed");
        return (T)UNSAFE.getObject(cls, UNSAFE.staticFieldOffset(field));
    }

    public static void writeStaticField(Class<?> cls, Field field, Object value) {
        Objects.requireNonNull(UNSAFE, "Unsafe initialization failed");
        UNSAFE.putObject(cls, UNSAFE.staticFieldOffset(field), value);
    }

    static {
        Unsafe unsafe = null;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UNSAFE = unsafe;
    }
}

