/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway;

import com.alipay.sofa.ark.spi.event.AbstractArkEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStartupEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizStopEvent;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import com.alipay.sofa.koupleless.common.util.ArkUtils;
import com.alipay.sofa.koupleless.common.util.SpringUtils;
import com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway.Forwards;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompositeBizForwardsHandler
implements EventHandler<AbstractArkEvent> {
    private static final Map<ClassLoader, Forwards> forwardsMap = new ConcurrentHashMap<ClassLoader, Forwards>();

    public void handleEvent(AbstractArkEvent event) {
        if (ArkUtils.isMasterBiz()) {
            return;
        }
        Object obj = event.getSource();
        if (obj instanceof Biz) {
            Biz biz = (Biz)obj;
            this.handleBizEvent((AbstractArkEvent<Biz>)event, biz);
        }
    }

    private void handleBizEvent(AbstractArkEvent<Biz> event, Biz biz) {
        Object forwards;
        if (event instanceof AfterBizStartupEvent && (forwards = SpringUtils.getBean((Biz)biz, (String)"forwards")) instanceof Forwards) {
            forwardsMap.put(biz.getBizClassLoader(), (Forwards)forwards);
        }
        if (event instanceof BeforeBizStopEvent) {
            forwardsMap.remove(biz.getBizClassLoader());
        }
    }

    public int getPriority() {
        return 0;
    }

    public static Map<ClassLoader, Forwards> getBizForwards() {
        return Collections.unmodifiableMap(forwardsMap);
    }
}

