/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway;

import com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway.Forward;
import com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway.ForwardItem;
import com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway.ForwardItemComparator;
import com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway.ForwardPath;
import com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway.Forwards;
import com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway.GatewayProperties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class ForwardItems {
    private static final String EMPTY = "";
    private static final String CONTEXT_PATH_PREFIX = "/";
    private static final String PATH_PREFIX = "/";

    public static void init(Forwards bean, GatewayProperties gatewayProperties) {
        List<Forward> forwards = gatewayProperties.getForwards();
        List<ForwardItem> items = ForwardItems.toForwardItems(forwards);
        items.sort(ForwardItemComparator.getInstance());
        bean.setItems(items);
    }

    private static List<ForwardItem> toForwardItems(List<Forward> forwards) {
        if (CollectionUtils.isEmpty(forwards)) {
            return Collections.emptyList();
        }
        LinkedList<ForwardItem> items = new LinkedList<ForwardItem>();
        for (Forward forward : forwards) {
            items.addAll(ForwardItems.toForwardItems(forward));
        }
        return items;
    }

    private static List<ForwardItem> toForwardItems(Forward forward) {
        Set<Object> paths;
        String contextPath;
        Set<String> hosts = forward.getHosts();
        if (CollectionUtils.isEmpty(hosts)) {
            hosts = Collections.singleton(EMPTY);
        }
        if (!(contextPath = forward.getContextPath()).startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (CollectionUtils.isEmpty(paths = forward.getPaths())) {
            ForwardPath path = new ForwardPath();
            path.setFrom("/");
            path.setTo("/");
            paths = Collections.singleton(path);
        } else {
            for (ForwardPath forwardPath : paths) {
                String to;
                String from = forwardPath.getFrom();
                if (!from.startsWith("/")) {
                    forwardPath.setFrom("/" + from);
                }
                if ((to = forwardPath.getTo()) == null) {
                    forwardPath.setTo(forwardPath.getFrom());
                    continue;
                }
                if (to.startsWith("/")) continue;
                forwardPath.setTo("/" + to);
            }
        }
        LinkedList<ForwardItem> items = new LinkedList<ForwardItem>();
        for (String host : hosts) {
            for (ForwardPath forwardPath : paths) {
                ForwardItem item = new ForwardItem(contextPath, host, forwardPath.getFrom(), forwardPath.getTo());
                items.add(item);
            }
        }
        return items;
    }

    private ForwardItems() {
    }
}

