/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway;

import com.alipay.sofa.koupleless.ext.autoconfigure.web.gateway.ForwardItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class Forwards {
    public static final String ROOT_PATH = "/";
    private static final String PATH_SEPARATOR = "/";
    private static final String HOST_SEPARATOR = ".";
    private List<ForwardItem> items;
    private Map<String, ForwardItem> contextPathMap;

    public void setItems(List<ForwardItem> items) {
        this.items = items;
        this.contextPathMap = new ConcurrentHashMap<String, ForwardItem>();
    }

    public ForwardItem getForwardItem(String host, String path) {
        String key = host + path;
        return this.contextPathMap.computeIfAbsent(key, k -> this.doGetForwardItem(host, path));
    }

    private ForwardItem doGetForwardItem(String host, String path) {
        for (ForwardItem item : this.items) {
            boolean matchPath;
            boolean matchHost = !StringUtils.hasLength((String)item.getHost()) || Objects.equals(item.getHost(), host) || host.startsWith(item.getHost() + HOST_SEPARATOR);
            boolean bl = matchPath = Objects.equals(path, item.getFrom()) || Objects.equals("/", item.getFrom()) || path.startsWith(item.getFrom() + "/");
            if (!matchHost || !matchPath) continue;
            return item;
        }
        return null;
    }
}

