/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alipay.sofa.koupleless.test.suite.biz;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.net.URLClassLoader;
import java.util.List;

/**
 * <p>TestBizConfig class.</p>
 *
 * @author CodeNoobKing
 * @version 1.0.0
 * @since 2024/3/21
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@Builder
public class TestBizConfig {
    private String       bootstrapClassName;
    private String       bizName;
    private String       bizVersion;
    private List<String> testClassNames;
    private List<String> includeClassPatterns;
    private ClassLoader  baseClassLoader;
    private List<String> preFindResourceUrlKeyWords;
    private List<String> excludeArtifactIds;
    private List<String> includeArtifactIds;
}
