/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.logging.log4j2;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

@Plugin(name="SOFAConfigurationFactory", category="ConfigurationFactory")
@Order(value=0x7FFFFFFF)
public class SOFAConfigurationFactory
extends ConfigurationFactory {
    private final String[] TYPES = new String[]{"log4j2/log-conf.xml", "log4j2/log-conf-custom.xml"};

    protected String[] getSupportedTypes() {
        return this.TYPES;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        if (source != null && source != ConfigurationSource.NULL_SOURCE) {
            return loggerContext.getExternalContext() != null ? new SOFAConfiguration() : new XmlConfiguration(loggerContext, source);
        }
        return null;
    }

    public static final class SOFAConfiguration
    extends DefaultConfiguration {
        private SOFAConfiguration() {
            this.isShutdownHookEnabled = false;
            String levelName = System.getProperty("org.apache.logging.log4j.level", Level.INFO.name());
            Level level = Level.valueOf((String)levelName);
            this.getRootLogger().setLevel(level != null ? level : Level.INFO);
        }
    }
}

