/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.api.ConfigDataObserver;
import com.alipay.sofa.registry.client.api.Configurator;
import com.alipay.sofa.registry.client.api.EventBus;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.api.SubscriberDataObserver;
import com.alipay.sofa.registry.client.event.ConfiguratorProcessEvent;
import com.alipay.sofa.registry.client.event.SubscriberProcessEvent;
import com.alipay.sofa.registry.client.factory.NamedThreadFactory;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.task.ObserverHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class DefaultObserverHandler
implements ObserverHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultObserverHandler.class);
    private static final int KEEP_ALIVE_TIME = 60;
    private ExecutorService executor;
    private EventBus eventBus;
    private RegistryClientConfig config;

    public DefaultObserverHandler(RegistryClientConfig config, EventBus eventBus) {
        this.config = config;
        this.executor = new ThreadPoolExecutor(config.getObserverThreadCoreSize(), config.getObserverThreadMaxSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(config.getObserverThreadQueueLength()), new NamedThreadFactory("ObserverNotifyThread"));
        this.eventBus = eventBus;
    }

    @Override
    public void notify(Subscriber subscriber) {
        this.executor.submit(new SubscriberNotifyTask(subscriber));
    }

    @Override
    public void notify(Configurator configurator) {
        this.executor.submit(new ConfiguratorNotifyTask(configurator));
    }

    public class ConfiguratorNotifyTask
    implements Runnable {
        private Configurator configurator;

        public ConfiguratorNotifyTask(Configurator configurator) {
            this.configurator = configurator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (null == this.configurator) {
                return;
            }
            ConfiguratorProcessEvent event = new ConfiguratorProcessEvent();
            long start = System.currentTimeMillis();
            event.setStart(start);
            event.setConfig(DefaultObserverHandler.this.config);
            event.setConfigurator(this.configurator);
            try {
                ConfigDataObserver dataObserver = this.configurator.getDataObserver();
                if (null != dataObserver) {
                    dataObserver.handleData(this.configurator.getDataId(), this.configurator.peekData());
                }
                LOGGER.info("[notify] notify configurator success, dataId: {}, registId:{}, cost: {}ms", new Object[]{this.configurator.getDataId(), this.configurator.getRegistId(), System.currentTimeMillis() - start});
            }
            catch (Exception e) {
                LOGGER.error("[notify] ConfiguratorNotifyTask execute error, dataId: {}", (Object)this.configurator.getDataId(), (Object)e);
                event.setThrowable(e);
            }
            finally {
                event.setEnd(System.currentTimeMillis());
                if (null != DefaultObserverHandler.this.eventBus) {
                    DefaultObserverHandler.this.eventBus.post(event);
                }
            }
        }
    }

    public class SubscriberNotifyTask
    implements Runnable {
        private Subscriber subscriber;

        public SubscriberNotifyTask(Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (null == this.subscriber) {
                return;
            }
            SubscriberProcessEvent event = new SubscriberProcessEvent();
            long start = System.currentTimeMillis();
            event.setStart(start);
            event.setConfig(DefaultObserverHandler.this.config);
            event.setSubscriber(this.subscriber);
            try {
                SubscriberDataObserver dataObserver = this.subscriber.getDataObserver();
                if (null != dataObserver) {
                    dataObserver.handleData(this.subscriber.getDataId(), this.subscriber.peekData());
                }
                LOGGER.info("[notify] notify subscriber success, dataId: {}, registId:{}, cost: {}ms", new Object[]{this.subscriber.getDataId(), this.subscriber.getRegistId(), System.currentTimeMillis() - start});
            }
            catch (Exception e) {
                LOGGER.error("[notify] SubscriberNotifyTask execute error, dataId: {}", (Object)this.subscriber.getDataId(), (Object)e);
                event.setThrowable(e);
            }
            finally {
                event.setEnd(System.currentTimeMillis());
                if (null != DefaultObserverHandler.this.eventBus) {
                    DefaultObserverHandler.this.eventBus.post(event);
                }
            }
        }
    }
}

