/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.util;

import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class HttpClientUtils {
    private static final char AND = '&';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> params, RegistryClientConfig config) throws Exception {
        HttpURLConnection httpURLConnection = HttpClientUtils.create(HttpClientUtils.getFullPath(url, params), config);
        httpURLConnection.setRequestMethod("GET");
        BufferedReader reader = null;
        try {
            StringBuilder stringBuffer = new StringBuilder();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode == 200) {
                String strCurrentLine;
                String charset = httpURLConnection.getContentEncoding();
                reader = charset != null ? new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), charset)) : new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                while ((strCurrentLine = reader.readLine()) != null) {
                    stringBuffer.append(strCurrentLine).append("\n");
                }
                if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                String string = stringBuffer.toString();
                return string;
            }
        }
        finally {
            httpURLConnection.disconnect();
            if (null != reader) {
                reader.close();
            }
        }
        return null;
    }

    private static HttpURLConnection create(String httpUrl, RegistryClientConfig config) throws Exception {
        URL url = new URL(httpUrl);
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection httpConnection = (HttpURLConnection)urlConnection;
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        httpConnection.setUseCaches(false);
        httpConnection.setRequestProperty("Content-type", "text/plain");
        httpConnection.setConnectTimeout(config.getConnectTimeout());
        httpConnection.setReadTimeout(config.getSocketTimeout());
        return httpConnection;
    }

    private static String getFullPath(String url, Map<String, String> params) {
        StringBuilder sb = new StringBuilder(url);
        if (params != null) {
            sb.append("?");
            for (Map.Entry<String, String> param : params.entrySet()) {
                sb.append(param.getKey());
                sb.append("=");
                sb.append(param.getValue());
                sb.append("&");
            }
            if (sb.charAt(sb.length() - 1) == '&') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }
}

