/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.remoting.ServerManager;
import com.alipay.sofa.registry.client.remoting.ServerNode;
import com.alipay.sofa.registry.client.util.HttpClientUtils;
import com.alipay.sofa.registry.client.util.ServerNodeParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class DefaultServerManager
implements ServerManager {
    public static final int MIN_RETRY_INTERVAL = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServerManager.class);
    private RegistryClientConfig config;
    private Set<ServerNode> serverNodes;
    private SyncServerListThread syncServerListTask;
    private AtomicBoolean inited = new AtomicBoolean(false);

    public DefaultServerManager(RegistryClientConfig config) {
        this.config = config;
        this.serverNodes = new HashSet<ServerNode>();
        this.syncServerListTask = new SyncServerListThread(config);
    }

    @Override
    public List<ServerNode> getServerList() {
        if (this.inited.compareAndSet(false, true)) {
            this.syncServerListTask.start();
        }
        if (this.serverNodes.isEmpty()) {
            this.syncServerList();
        }
        return new ArrayList<ServerNode>(this.serverNodes);
    }

    @Override
    public ServerNode random() {
        List<ServerNode> urls = this.getServerList();
        if (null == urls || urls.size() == 0) {
            return null;
        }
        Random random = new Random();
        return urls.get(random.nextInt(urls.size()));
    }

    private void syncServerList() {
        String url = String.format("http://%s:%d/api/servers/queryWithWeight", this.config.getRegistryEndpoint(), this.config.getRegistryEndpointPort());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("env", this.config.getEnv());
        params.put("zone", this.config.getZone());
        params.put("dataCenter", this.config.getDataCenter());
        params.put("appName", this.config.getAppName());
        params.put("instanceId", this.config.getInstanceId());
        try {
            String result = HttpClientUtils.get(url, params, this.config);
            if (null == result) {
                url = String.format("http://%s:%d/api/servers/query", this.config.getRegistryEndpoint(), this.config.getRegistryEndpointPort());
                result = HttpClientUtils.get(url, params, this.config);
            }
            if (null != result) {
                String[] servers = result.split(";");
                HashSet<ServerNode> tempNodes = new HashSet<ServerNode>();
                for (String server : servers) {
                    try {
                        ServerNode serverNode = ServerNodeParser.parse(server);
                        tempNodes.add(serverNode);
                    }
                    catch (Exception e) {
                        LOGGER.error("[serverManager] parse server node error, {}", (Object)server, (Object)e);
                    }
                }
                if (!tempNodes.equals(this.serverNodes)) {
                    this.serverNodes = tempNodes;
                    LOGGER.info("[serverManager] update nodes success, {}", tempNodes);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[serverManager] get server list error", (Throwable)e);
        }
    }

    class SyncServerListThread
    extends Thread {
        private RegistryClientConfig config;

        public SyncServerListThread(RegistryClientConfig config) {
            this.setName("SyncServerListThread");
            this.setDaemon(true);
            this.config = config;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int retryInterval = Math.max(10000, this.config.getSyncConfigRetryInterval());
                        Thread.sleep(retryInterval);
                        DefaultServerManager.this.syncServerList();
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("[serverManager] sync server list task error", e);
                    continue;
                }
                break;
            }
        }
    }
}

