/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.remoting.ServerNode;
import com.alipay.sofa.registry.client.util.StringUtils;
import java.util.Properties;

public class DefaultServerNode
implements ServerNode {
    private String url;
    private String host;
    private int port;
    private Properties properties;
    private static final String WEIGHT_KEY = "weight";

    public DefaultServerNode(String url, String host, int port, Properties properties) {
        this.url = url;
        this.host = host;
        this.port = port;
        this.properties = properties;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public int getWeight() {
        if (null == this.getProperties()) {
            return 0;
        }
        String weightStr = this.getProperties().getProperty(WEIGHT_KEY);
        if (StringUtils.isBlank(weightStr)) {
            return 0;
        }
        try {
            return Integer.parseInt(weightStr);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultServerNode)) {
            return false;
        }
        DefaultServerNode that = (DefaultServerNode)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultServerNode{url='" + this.url + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", properties=" + this.properties + '}';
    }
}

