/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.dataserver;

import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.WordCache;
import com.alipay.sofa.registry.util.DatumVersionUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Datum
implements Serializable {
    private static final long serialVersionUID = 5307489721610438103L;
    private String dataInfoId;
    private String dataCenter;
    private String dataId;
    private String instanceId;
    private String group;
    private Map<String, Publisher> pubMap = new ConcurrentHashMap<String, Publisher>();
    private long version;
    private boolean containsUnPub = false;

    public Datum() {
    }

    public Datum(String dataInfoId, String dataCenter) {
        this.dataInfoId = WordCache.getInstance().getWordCache(dataInfoId);
        this.dataCenter = WordCache.getInstance().getWordCache(dataCenter);
        this.updateVersion();
    }

    public Datum(Publisher publisher, String dataCenter) {
        this(publisher.getDataInfoId(), dataCenter);
        this.dataId = publisher.getDataId();
        this.instanceId = publisher.getInstanceId();
        this.group = publisher.getGroup();
        this.pubMap.put(publisher.getRegisterId(), publisher);
    }

    public Datum(Publisher publisher, String dataCenter, long version) {
        this.dataInfoId = publisher.getDataInfoId();
        this.dataCenter = WordCache.getInstance().getWordCache(dataCenter);
        this.version = version;
        this.dataId = publisher.getDataId();
        this.instanceId = publisher.getInstanceId();
        this.group = publisher.getGroup();
        this.pubMap.put(publisher.getRegisterId(), publisher);
    }

    public void updateVersion() {
        this.version = DatumVersionUtil.nextId();
    }

    public String getDataInfoId() {
        return this.dataInfoId;
    }

    public void setDataInfoId(String dataInfoId) {
        this.dataInfoId = WordCache.getInstance().getWordCache(dataInfoId);
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.dataCenter = WordCache.getInstance().getWordCache(dataCenter);
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = WordCache.getInstance().getWordCache(dataId);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = WordCache.getInstance().getWordCache(instanceId);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = WordCache.getInstance().getWordCache(group);
    }

    public Map<String, Publisher> getPubMap() {
        return this.pubMap;
    }

    public void setPubMap(Map<String, Publisher> pubMap) {
        this.pubMap = pubMap;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public boolean isContainsUnPub() {
        return this.containsUnPub;
    }

    public void setContainsUnPub(boolean containsUnPub) {
        this.containsUnPub = containsUnPub;
    }

    public static Datum internDatum(Datum datum) {
        datum.setDataCenter(datum.getDataCenter());
        datum.setDataInfoId(datum.getDataInfoId());
        datum.setDataId(datum.getDataId());
        datum.setGroup(datum.getGroup());
        datum.setInstanceId(datum.getInstanceId());
        Map<String, Publisher> pubMap = datum.getPubMap();
        if (pubMap != null && !pubMap.isEmpty()) {
            pubMap.forEach((registerId, publisher) -> {
                publisher.setRegisterId((String)registerId);
                Publisher.internPublisher(publisher);
            });
        }
        return datum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[Datum] dataInfoId=").append(this.dataInfoId).append(", dataId=").append(this.dataId).append(", dataCenter=").append(this.dataCenter).append(", instanceId=").append(this.instanceId).append(", version=").append(this.version).append(", pubMap=").append(this.pubMap);
        return sb.toString();
    }
}

