/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.metaserver;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.store.URL;

public class MetaNode
implements Node {
    private final Node.NodeType nodeType = Node.NodeType.META;
    private final URL nodeUrl;
    private final String dataCenter;
    private String name;
    private String regionId;
    private Node.NodeStatus nodeStatus;

    public MetaNode(URL nodeUrl, String dataCenter) {
        this.nodeUrl = nodeUrl;
        this.name = this.getIp();
        this.dataCenter = dataCenter;
        this.nodeStatus = Node.NodeStatus.INIT;
    }

    @Override
    public Node.NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public Node.NodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    @Override
    public URL getNodeUrl() {
        return this.nodeUrl;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public String getIp() {
        return this.nodeUrl == null ? "" : this.nodeUrl.getIpAddress();
    }

    @Override
    public void setNodeStatus(Node.NodeStatus nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetaNode{");
        sb.append("ip=").append(this.getIp());
        sb.append('}');
        return sb.toString();
    }
}

