/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.metaserver;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.store.URL;

public class SessionNode
implements Node {
    private URL nodeUrl;
    private String regionId;
    private String name;
    private Node.NodeStatus nodeStatus;

    public SessionNode(URL nodeUrl, String regionId) {
        this.nodeUrl = nodeUrl;
        this.regionId = regionId;
        this.nodeStatus = Node.NodeStatus.INIT;
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.SESSION;
    }

    @Override
    public URL getNodeUrl() {
        return this.nodeUrl;
    }

    public String getIp() {
        return this.nodeUrl == null ? "" : this.nodeUrl.getIpAddress();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionNode)) {
            return false;
        }
        SessionNode that = (SessionNode)o;
        if (this.nodeStatus != null ? !this.nodeStatus.equals((Object)that.nodeStatus) : that.nodeStatus != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.regionId != null ? !this.regionId.equals(that.regionId) : that.regionId != null) {
            return false;
        }
        return this.nodeUrl != null ? (this.nodeUrl.getAddressString() != null ? this.nodeUrl.getAddressString().equals(that.nodeUrl.getAddressString()) : that.nodeUrl.getAddressString() != null) : that.nodeUrl != null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.regionId != null ? this.regionId.hashCode() : 0);
        result = 31 * result + (this.nodeStatus != null ? this.nodeStatus.hashCode() : 0);
        result = 31 * result + (this.nodeUrl != null ? (this.nodeUrl.getAddressString() != null ? this.nodeUrl.getAddressString().hashCode() : 0) : 0);
        return result;
    }

    public void setNodeUrl(URL nodeUrl) {
        this.nodeUrl = nodeUrl;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Node.NodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    @Override
    public void setNodeStatus(Node.NodeStatus nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionNode{");
        sb.append("ip=").append(this.getIp());
        sb.append('}');
        return sb.toString();
    }
}

