/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.store;

import com.alipay.sofa.registry.common.model.ElementType;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Subscriber
extends BaseInfo {
    private static final long serialVersionUID = 98433360274932292L;
    private ScopeEnum scope;
    private ElementType elementType;
    private Map<String, PushContext> lastPushContexts = new ConcurrentHashMap<String, PushContext>();

    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public boolean checkVersion(String dataCenter, Long version) {
        PushContext lastPushContext = this.lastPushContexts.get(dataCenter);
        if (lastPushContext == null) {
            return version != null;
        }
        Long oldVersion = lastPushContext.pushVersion;
        if (oldVersion == null) {
            return version != null;
        }
        if (version != null) {
            return version > oldVersion;
        }
        return false;
    }

    public void checkAndUpdateVersion(String dataCenter, Long version) {
        this.checkAndUpdateVersion(dataCenter, version, -1);
    }

    public void checkAndUpdateVersion(String dataCenter, Long version, int pubCount) {
        PushContext pushContext;
        PushContext oldPushContext;
        while ((oldPushContext = this.lastPushContexts.putIfAbsent(dataCenter, pushContext = new PushContext(version, pubCount))) != null && (oldPushContext.pushVersion == null || pushContext.pushVersion != null && pushContext.pushVersion > oldPushContext.pushVersion) && !this.lastPushContexts.replace(dataCenter, oldPushContext, pushContext)) {
        }
    }

    public boolean allowPush(String dataCenter, int pubCount) {
        boolean allowPush = true;
        if (pubCount == 0) {
            PushContext pushContext = this.lastPushContexts.get(dataCenter);
            allowPush = pushContext == null || pushContext.pushPubCount != 0 || pushContext.pushVersion == null || pushContext.pushVersion <= 1L;
        }
        return allowPush;
    }

    public void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    @Override
    @JsonIgnore
    public StoreData.DataType getDataType() {
        return StoreData.DataType.SUBSCRIBER;
    }

    @Override
    protected String getOtherInfo() {
        StringBuilder sb = new StringBuilder("scope=");
        sb.append(this.scope).append(",");
        sb.append("elementType=").append((Object)this.elementType).append(",");
        sb.append("pushVersion=").append(this.lastPushContexts);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Subscriber{");
        sb.append("scope=").append(this.scope);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", lastPushContexts=").append(this.lastPushContexts);
        sb.append(", super=").append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    public static Subscriber internSubscriber(Subscriber subscriber) {
        subscriber.setRegisterId(subscriber.getRegisterId());
        subscriber.setDataInfoId(subscriber.getDataInfoId());
        subscriber.setInstanceId(subscriber.getInstanceId());
        subscriber.setGroup(subscriber.getGroup());
        subscriber.setDataId(subscriber.getDataId());
        subscriber.setClientId(subscriber.getClientId());
        subscriber.setCell(subscriber.getCell());
        subscriber.setProcessId(subscriber.getProcessId());
        subscriber.setAppName(subscriber.getAppName());
        return subscriber;
    }

    static class PushContext {
        private Long pushVersion;
        private int pushPubCount;

        public PushContext(Long pushVersion, int pushPubCount) {
            this.pushVersion = pushVersion;
            this.pushPubCount = pushPubCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PushContext{");
            sb.append("pushVersion=").append(this.pushVersion);
            sb.append(", pushPubCount=").append(this.pushPubCount);
            sb.append('}');
            return sb.toString();
        }
    }
}

