/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alipay.sofa.registry.common.model.slot;

import com.alipay.sofa.registry.common.model.GenericResponse;
import java.util.Map;

/**
 * @author xiaojian.xj
 * @version : MultiSlotAccessGenericResponse.java, v 0.1 2022年06月20日 16:28 xiaojian.xj Exp $
 */
public class MultiSlotAccessGenericResponse<T> extends GenericResponse<T> {

  private final Map<String, SlotAccess> slotAccessMap;

  public MultiSlotAccessGenericResponse(
      boolean success, String message, T data, Map<String, SlotAccess> slotAccessMap) {
    this.slotAccessMap = slotAccessMap;
    this.setData(data);
    this.setSuccess(success);
    this.setMessage(message);
  }

  /**
   * Getter method for property <tt>slotAccessMap</tt>.
   *
   * @return property value of slotAccessMap
   */
  public Map<String, SlotAccess> getSlotAccessMap() {
    return slotAccessMap;
  }

  public static <T> MultiSlotAccessGenericResponse<T> failedResponse(String msg) {
    return new MultiSlotAccessGenericResponse(false, msg, null, null);
  }
}
