/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.timer;

import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;

public class RecycleAsyncHashedWheelTimer
extends AsyncHashedWheelTimer {
    public RecycleAsyncHashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, int threadSize, int queueSize, ThreadFactory asyncThreadFactory, AsyncHashedWheelTimer.TaskFailedCallback taskFailedCallback) {
        super(threadFactory, tickDuration, unit, ticksPerWheel, threadSize, queueSize, asyncThreadFactory, taskFailedCallback);
    }

    public RecycleAsyncHashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, Executor asyncExecutor, AsyncHashedWheelTimer.TaskFailedCallback taskFailedCallback) {
        super(threadFactory, tickDuration, unit, ticksPerWheel, asyncExecutor, taskFailedCallback);
    }

    public Timeout newTimeout(TimerTask task, long firstDelay, long recycleDelay, TimeUnit unit, BooleanSupplier checkCondition) {
        return super.newTimeout(new RecycleAsyncTimerTask(task, recycleDelay, unit, checkCondition), firstDelay, unit);
    }

    public Timeout newTimeout(TimerTask task, long recycleDelay, TimeUnit unit, BooleanSupplier checkCondition) {
        return super.newTimeout(new RecycleAsyncTimerTask(task, recycleDelay, unit, checkCondition), recycleDelay, unit);
    }

    class RecycleAsyncTimerTask
    implements TimerTask,
    Runnable {
        private final TimerTask timerTask;
        private final long recycleDelay;
        private final TimeUnit delayUnit;
        private final BooleanSupplier checkCondition;
        private Timeout timeout;

        public RecycleAsyncTimerTask(TimerTask timerTask, long recycleDelay, TimeUnit unit, BooleanSupplier checkCondition) {
            this.timerTask = timerTask;
            this.recycleDelay = recycleDelay;
            this.delayUnit = unit;
            this.checkCondition = checkCondition;
        }

        public void run(Timeout timeout) {
            this.timeout = timeout;
            try {
                RecycleAsyncHashedWheelTimer.this.executor.execute(this);
            }
            catch (RejectedExecutionException e) {
                RecycleAsyncHashedWheelTimer.this.taskFailedCallback.executionRejected(e);
            }
            catch (Throwable e) {
                RecycleAsyncHashedWheelTimer.this.taskFailedCallback.executionFailed(e);
            }
        }

        @Override
        public void run() {
            try {
                this.timerTask.run(this.timeout);
            }
            catch (Throwable e) {
                RecycleAsyncHashedWheelTimer.this.taskFailedCallback.executionFailed(e);
            }
            finally {
                if (this.checkCondition.getAsBoolean()) {
                    RecycleAsyncHashedWheelTimer.this.newTimeout(this.timerTask, this.recycleDelay, this.delayUnit, this.checkCondition);
                }
            }
        }
    }
}

