/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.util;

public class DatumVersionUtil {
    private static long sequence = 0L;
    private static long twepoch = 1546272000000L;
    private static long sequenceBits;
    private static long timestampLeftShift;
    private static long sequenceMask;
    private static long lastTimestamp;

    public static synchronized long nextId() {
        long timestamp = DatumVersionUtil.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & sequenceMask) == 0L) {
                timestamp = DatumVersionUtil.untilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - twepoch << (int)timestampLeftShift | sequence;
    }

    public static long getRealTimestamp(long id) {
        return (id >> (int)timestampLeftShift) + twepoch;
    }

    private static long untilNextMillis(long lastTimestamp) {
        long timestamp = DatumVersionUtil.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = DatumVersionUtil.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    static {
        timestampLeftShift = sequenceBits = 15L;
        sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)sequenceBits;
        lastTimestamp = -1L;
    }
}

