/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.bolt;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.bolt.AsyncUserProcessorAdapter;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.remoting.bolt.ConnectionEventAdapter;
import com.alipay.sofa.registry.remoting.bolt.SyncUserProcessorAdapter;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class BoltClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltClient.class);
    private RpcClient rpcClient;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private int connectTimeout = 2000;
    private final int connNum;

    public BoltClient(int connNum) {
        this.rpcClient = new RpcClient();
        this.rpcClient.init();
        this.connNum = connNum;
    }

    public void initHandlers(List<ChannelHandler> channelHandlers) {
        ChannelHandler connectionEventHandler = null;
        for (ChannelHandler channelHandler : channelHandlers) {
            if (!ChannelHandler.HandlerType.LISENTER.equals((Object)channelHandler.getType())) continue;
            connectionEventHandler = channelHandler;
            break;
        }
        this.rpcClient.addConnectionEventProcessor(ConnectionEventType.CONNECT, this.newConnectionEventAdapter(connectionEventHandler, ConnectionEventType.CONNECT));
        this.rpcClient.addConnectionEventProcessor(ConnectionEventType.CLOSE, this.newConnectionEventAdapter(connectionEventHandler, ConnectionEventType.CLOSE));
        this.rpcClient.addConnectionEventProcessor(ConnectionEventType.EXCEPTION, this.newConnectionEventAdapter(connectionEventHandler, ConnectionEventType.EXCEPTION));
        for (ChannelHandler channelHandler : channelHandlers) {
            if (!ChannelHandler.HandlerType.PROCESSER.equals((Object)channelHandler.getType())) continue;
            if (ChannelHandler.InvokeType.SYNC.equals((Object)channelHandler.getInvokeType())) {
                this.rpcClient.registerUserProcessor((UserProcessor)this.newSyncProcessor(channelHandler));
                continue;
            }
            this.rpcClient.registerUserProcessor((UserProcessor)this.newAsyncProcessor(channelHandler));
        }
    }

    protected ConnectionEventProcessor newConnectionEventAdapter(ChannelHandler connectionEventHandler, ConnectionEventType connectEventType) {
        return new ConnectionEventAdapter(connectEventType, connectionEventHandler, null);
    }

    protected AsyncUserProcessorAdapter newAsyncProcessor(ChannelHandler channelHandler) {
        return new AsyncUserProcessorAdapter(channelHandler);
    }

    protected SyncUserProcessorAdapter newSyncProcessor(ChannelHandler channelHandler) {
        return new SyncUserProcessorAdapter(channelHandler);
    }

    public Channel connect(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Create connection url can not be null!");
        }
        try {
            Connection connection = this.getBoltConnection(this.rpcClient, url);
            BoltChannel channel = new BoltChannel();
            channel.setConnection(connection);
            return channel;
        }
        catch (RemotingException e) {
            LOGGER.error("Bolt client connect server got a RemotingException! target url:" + url, (Throwable)e);
            throw new RuntimeException("Bolt client connect server got a RemotingException!", e);
        }
    }

    protected Connection getBoltConnection(RpcClient rpcClient, URL url) throws RemotingException {
        Url boltUrl = this.createBoltUrl(url);
        try {
            Connection connection = rpcClient.getConnection(boltUrl, this.connectTimeout);
            if (connection == null || !connection.isFine()) {
                if (connection != null) {
                    connection.close();
                }
                throw new RemotingException("Get bolt connection failed for boltUrl: " + boltUrl);
            }
            return connection;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("BoltClient rpcClient.getConnection InterruptedException! target boltUrl:" + boltUrl, e);
        }
    }

    protected Url createBoltUrl(URL url) {
        Url boltUrl = new Url(url.getIpAddress(), url.getPort());
        boltUrl.setProtocol((byte)1);
        boltUrl.setConnNum(this.connNum);
        boltUrl.setConnWarmup(true);
        return boltUrl;
    }

    public Channel getChannel(URL url) {
        try {
            Connection connection = this.getBoltConnection(this.rpcClient, url);
            BoltChannel channel = new BoltChannel();
            channel.setConnection(connection);
            return channel;
        }
        catch (RemotingException e) {
            LOGGER.error("Bolt client connect server got a RemotingException! target url:" + url, (Throwable)e);
            throw new RuntimeException("Bolt client connect server got a RemotingException!", e);
        }
    }

    public InetSocketAddress getLocalAddress() {
        return NetUtil.getLocalSocketAddress();
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.rpcClient.shutdown();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public Object sendSync(URL url, Object message, int timeoutMillis) {
        try {
            return this.rpcClient.invokeSync(this.createBoltUrl(url), message, timeoutMillis);
        }
        catch (RemotingException e) {
            String msg = "Bolt Client sendSync message RemotingException! target url:" + url;
            LOGGER.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bolt Client sendSync message InterruptedException! target url:" + url, e);
        }
    }

    public Object sendSync(Channel channel, Object message, int timeoutMillis) {
        if (channel != null && channel.isConnected()) {
            BoltChannel boltChannel = (BoltChannel)channel;
            try {
                return this.rpcClient.invokeSync(boltChannel.getConnection(), message, timeoutMillis);
            }
            catch (RemotingException e) {
                LOGGER.error("Bolt Client sendSync message RemotingException! target boltUrl:" + boltChannel.getRemoteAddress(), (Throwable)e);
                throw new RuntimeException("Bolt Client sendSync message RemotingException!", e);
            }
            catch (InterruptedException e) {
                LOGGER.error("Bolt Client sendSync message InterruptedException! target boltUrl:" + boltChannel.getRemoteAddress(), (Throwable)e);
                throw new RuntimeException("Bolt Client sendSync message InterruptedException!", e);
            }
        }
        throw new IllegalArgumentException("Input channel: " + channel + " error! channel cannot be null,or channel must be connected!");
    }

    public void sendCallback(URL url, Object message, final CallbackHandler callbackHandler, int timeoutMillis) {
        try {
            Connection connection = this.getBoltConnection(this.rpcClient, url);
            final BoltChannel channel = new BoltChannel();
            channel.setConnection(connection);
            this.rpcClient.invokeWithCallback(connection, message, new InvokeCallback(){

                public void onResponse(Object result) {
                    callbackHandler.onCallback((Channel)channel, result);
                }

                public void onException(Throwable e) {
                    callbackHandler.onException((Channel)channel, e);
                }

                public Executor getExecutor() {
                    return callbackHandler.getExecutor();
                }
            }, timeoutMillis);
            return;
        }
        catch (RemotingException e) {
            String msg = "Bolt Client sendSync message RemotingException! target url:" + url;
            LOGGER.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }
}

