/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.bolt;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcServer;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.bolt.AsyncUserProcessorAdapter;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.remoting.bolt.ConnectionEventAdapter;
import com.alipay.sofa.registry.remoting.bolt.SyncUserProcessorAdapter;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class BoltServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltServer.class);
    private static final Logger PUSH_LOGGER = LoggerFactory.getLogger((String)"SESSION-PUSH", (String)"[Server]");
    private final URL url;
    private final List<ChannelHandler> channelHandlers;
    private RpcServer boltServer;
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private AtomicBoolean initHandler = new AtomicBoolean(false);

    public BoltServer(URL url, List<ChannelHandler> channelHandlers) {
        this.channelHandlers = channelHandlers;
        this.url = url;
    }

    public void startServer() {
        if (this.isStarted.compareAndSet(false, true)) {
            try {
                this.boltServer = new RpcServer(this.url.getPort(), true);
                this.initHandler();
                this.boltServer.start();
            }
            catch (Exception e) {
                this.isStarted.set(false);
                LOGGER.error("Start bolt server error!", (Throwable)e);
                throw new RuntimeException("Start bolt server error!", e);
            }
        }
    }

    private void stopServer() {
        if (this.boltServer != null && this.isStarted.get()) {
            try {
                this.boltServer.stop();
            }
            catch (Exception e) {
                LOGGER.error("Stop bolt server error!", (Throwable)e);
                throw new RuntimeException("Stop bolt server error!", e);
            }
        }
    }

    public void initServer() {
        try {
            this.boltServer = new RpcServer(this.url.getPort(), true);
            this.initHandler();
        }
        catch (Exception e) {
            LOGGER.error("Init bolt server error!", (Throwable)e);
            throw new RuntimeException("Init bolt server error!", e);
        }
    }

    private void initHandler() {
        if (this.initHandler.compareAndSet(false, true)) {
            this.boltServer.addConnectionEventProcessor(ConnectionEventType.CONNECT, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.CONNECT, this.getConnectionEventHandler(), this));
            this.boltServer.addConnectionEventProcessor(ConnectionEventType.CLOSE, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.CLOSE, this.getConnectionEventHandler(), this));
            this.boltServer.addConnectionEventProcessor(ConnectionEventType.EXCEPTION, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.EXCEPTION, this.getConnectionEventHandler(), this));
            this.registerUserProcessorHandler();
        }
    }

    private ChannelHandler getConnectionEventHandler() {
        if (this.channelHandlers != null) {
            for (ChannelHandler channelHandler : this.channelHandlers) {
                if (!ChannelHandler.HandlerType.LISENTER.equals((Object)channelHandler.getType())) continue;
                return channelHandler;
            }
        }
        return null;
    }

    private void registerUserProcessorHandler() {
        if (this.channelHandlers != null) {
            for (ChannelHandler channelHandler : this.channelHandlers) {
                if (!ChannelHandler.HandlerType.PROCESSER.equals((Object)channelHandler.getType())) continue;
                if (ChannelHandler.InvokeType.SYNC.equals((Object)channelHandler.getInvokeType())) {
                    this.boltServer.registerUserProcessor((UserProcessor)new SyncUserProcessorAdapter(channelHandler));
                    continue;
                }
                this.boltServer.registerUserProcessor((UserProcessor)new AsyncUserProcessorAdapter(channelHandler));
            }
        }
    }

    public boolean isOpen() {
        return this.isStarted.get();
    }

    public Collection<Channel> getChannels() {
        HashSet<Channel> chs = new HashSet<Channel>();
        if (!this.channels.isEmpty()) {
            Iterator<Channel> it = this.channels.values().iterator();
            while (it.hasNext()) {
                Channel channel = it.next();
                if (channel.isConnected()) {
                    chs.add(channel);
                    continue;
                }
                it.remove();
            }
        }
        return chs;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        Channel channel = this.channels.get(NetUtil.toAddressString((InetSocketAddress)remoteAddress));
        if (channel != null && channel.isConnected()) {
            return channel;
        }
        return null;
    }

    public Channel getChannel(URL url) {
        Channel channel = this.channels.get(url.getAddressString());
        if (channel != null && channel.isConnected()) {
            return channel;
        }
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.url.getPort());
    }

    public void close() {
        if (this.isStarted.compareAndSet(true, false)) {
            this.stopServer();
        }
    }

    public void close(Channel channel) {
        if (null != channel) {
            this.channels.remove(NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress()));
            BoltChannel boltChannel = (BoltChannel)channel;
            Connection connection = boltChannel.getConnection();
            if (null != connection && connection.isFine()) {
                connection.close();
            }
        }
    }

    public boolean isClosed() {
        return !this.isStarted.get();
    }

    public Object sendSync(Channel channel, Object message, int timeoutMillis) {
        if (channel != null && channel.isConnected()) {
            Url boltUrl = null;
            try {
                boltUrl = new Url(channel.getRemoteAddress().getAddress().getHostAddress(), channel.getRemoteAddress().getPort());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Bolt Server sendSync message:{} , target url:{}", message, (Object)boltUrl);
                }
                return this.boltServer.invokeSync(boltUrl, message, timeoutMillis);
            }
            catch (RemotingException e) {
                LOGGER.error("Bolt Server sendSync message RemotingException! target url:" + boltUrl, (Throwable)e);
                throw new RuntimeException("Bolt Server sendSync message RemotingException!", e);
            }
            catch (InterruptedException e) {
                LOGGER.error("Bolt Server sendSync message InterruptedException! target url:" + boltUrl, (Throwable)e);
                throw new RuntimeException("Bolt Server sendSync message InterruptedException!", e);
            }
        }
        throw new IllegalArgumentException("Send message connection can not be null or connection not be connected!");
    }

    public void sendCallback(final Channel channel, Object message, final CallbackHandler callbackHandler, int timeoutMillis) {
        if (channel != null && channel.isConnected()) {
            Url boltUrl = null;
            try {
                boltUrl = new Url(channel.getRemoteAddress().getAddress().getHostAddress(), channel.getRemoteAddress().getPort());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Bolt Server sendSync message:{} , target url:{}", message, (Object)boltUrl);
                }
                this.boltServer.invokeWithCallback(boltUrl, message, new InvokeCallback(){

                    public void onResponse(Object result) {
                        callbackHandler.onCallback(channel, result);
                    }

                    public void onException(Throwable e) {
                        callbackHandler.onException(channel, e);
                    }

                    public Executor getExecutor() {
                        return callbackHandler.getExecutor();
                    }
                }, timeoutMillis);
                return;
            }
            catch (RemotingException e) {
                throw new RuntimeException("Bolt Server invoke with callback RemotingException!", e);
            }
            catch (InterruptedException e) {
                PUSH_LOGGER.error("Bolt Server invoke with callback InterruptedException! target url:" + boltUrl, (Throwable)e);
                throw new RuntimeException("Bolt Server invoke with callback InterruptedException!", e);
            }
        }
        throw new IllegalArgumentException("Send message connection can not be null or connection not be connected!");
    }

    public void addChannel(Channel channel) {
        this.channels.putIfAbsent(NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress()), channel);
    }

    public void removeChannel(Channel channel) {
        this.channels.remove(NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress()));
    }

    public RpcServer getRpcServer() {
        return this.boltServer;
    }

    public int getChannelCount() {
        return this.channels.size();
    }
}

