/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.bolt.exchange;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.bolt.BoltClient;
import com.alipay.sofa.registry.remoting.bolt.BoltServer;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BoltExchange
implements Exchange<ChannelHandler> {
    private Map<String, Client> clients = new ConcurrentHashMap<String, Client>();
    private ConcurrentHashMap<Integer, Server> serverMap = new ConcurrentHashMap();

    public Client connect(String serverType, URL serverUrl, ChannelHandler ... channelHandlers) {
        return this.connect(serverType, 1, serverUrl, channelHandlers);
    }

    public Client connect(String serverType, int connNum, URL serverUrl, ChannelHandler ... channelHandlers) {
        if (channelHandlers == null) {
            throw new IllegalArgumentException("channelHandlers cannot be null!");
        }
        Client client = this.clients.computeIfAbsent(serverType, key -> this.newBoltClient(connNum, channelHandlers));
        client.connect(serverUrl);
        return client;
    }

    public Server open(URL url, ChannelHandler ... channelHandlers) {
        if (channelHandlers == null) {
            throw new IllegalArgumentException("channelHandlers cannot be null!");
        }
        BoltServer server = this.createBoltServer(url, channelHandlers);
        this.setServer(server, url);
        server.startServer();
        return server;
    }

    public Client getClient(String serverType) {
        return this.clients.get(serverType);
    }

    public Server getServer(Integer port) {
        return this.serverMap.get(port);
    }

    public void setServer(Server server, URL url) {
        this.serverMap.putIfAbsent(url.getPort(), server);
    }

    private BoltClient newBoltClient(int connNum, ChannelHandler[] channelHandlers) {
        BoltClient boltClient = this.createBoltClient(connNum);
        boltClient.initHandlers(Arrays.asList(channelHandlers));
        return boltClient;
    }

    protected BoltClient createBoltClient(int connNum) {
        return new BoltClient(connNum);
    }

    protected BoltServer createBoltServer(URL url, ChannelHandler[] channelHandlers) {
        return new BoltServer(url, Arrays.asList(channelHandlers));
    }
}

