/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.bootstrap;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerBootstrap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;

public class MetaServerInitializerConfiguration
implements SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaServerInitializerConfiguration.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    @Autowired
    private MetaServerBootstrap metaServerBootstrap;

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        try {
            this.metaServerBootstrap.doInitialized();
            LOGGER.info("Started MetaServer");
            this.running.set(true);
        }
        catch (Exception ex) {
            this.running.set(false);
            LOGGER.error("Could not initialize Meta server!", (Throwable)ex);
        }
    }

    public void stop() {
        this.running.set(false);
        this.metaServerBootstrap.destroy();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public void stop(Runnable callback) {
        callback.run();
        this.running.set(false);
    }
}

