/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.node.impl;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataCenterNodes;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.StatusConfirmRequest;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.meta.bootstrap.ServiceFactory;
import com.alipay.sofa.registry.server.meta.node.DataNodeService;
import com.alipay.sofa.registry.server.meta.remoting.connection.NodeConnectManager;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.meta.store.StoreService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeServiceImpl
implements DataNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeServiceImpl.class);
    @Autowired
    private NodeExchanger dataNodeExchanger;
    @Autowired
    private StoreService dataStoreService;
    @Autowired
    private AbstractServerHandler dataConnectionHandler;

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.DATA;
    }

    @Override
    public void pushDataNodes(final NodeChangeResult nodeChangeResult, Map<String, DataNode> targetNodes, boolean confirm, String confirmNodeIp) {
        if (nodeChangeResult != null) {
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            NodeConnectManager nodeConnectManager = this.getNodeConnectManager();
            Collection<InetSocketAddress> connections = nodeConnectManager.getConnections(null);
            StoreService storeService = ServiceFactory.getStoreService(Node.NodeType.DATA);
            DataCenterNodes dataCenterNodes = storeService.getDataCenterNodes();
            Map registeredNodes = dataCenterNodes.getNodes();
            if (registeredNodes == null || registeredNodes.isEmpty()) {
                LOGGER.error("Push dataNode list error! No data node registered!");
                throw new RuntimeException("Push dataNode list error! No data node registered!");
            }
            for (final InetSocketAddress address : connections) {
                try {
                    if (targetNodes != null && !targetNodes.isEmpty() ? !targetNodes.keySet().contains(address.getAddress().getHostAddress()) : !registeredNodes.keySet().contains(address.getAddress().getHostAddress())) continue;
                    Request<NodeChangeResult> nodeChangeRequestRequest = new Request<NodeChangeResult>(){

                        public NodeChangeResult getRequestBody() {
                            return nodeChangeResult;
                        }

                        public URL getRequestUrl() {
                            return new URL(address);
                        }
                    };
                    LOGGER.info("pushDataNodes sent url {},node type {}", (Object)address, (Object)nodeChangeResult.getNodeType());
                    Response response = this.dataNodeExchanger.request((Request)nodeChangeRequestRequest);
                    if (!confirm) continue;
                    Object result = response.getResult();
                    if (result instanceof CommonResponse) {
                        CommonResponse genericResponse = (CommonResponse)result;
                        if (genericResponse.isSuccess()) {
                            this.confirmStatus(address, confirmNodeIp);
                            continue;
                        }
                        LOGGER.error("NodeChange notify get response fail!");
                        throw new RuntimeException("NodeChange notify get response fail!");
                    }
                    LOGGER.error("NodeChange notify has not get response or response type illegal!");
                    throw new RuntimeException("NodeChange notify has not get response or response type illegal!");
                }
                catch (RequestException e) {
                    LOGGER.error("Push dataNode list error! " + e.getRequestMessage(), (Throwable)e);
                    exceptions.add(e);
                }
                catch (RuntimeException e) {
                    LOGGER.error("Push dataNode list runtime error! ", (Throwable)e);
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                throw new RuntimeException("DataNodeService push dataNode list error! errors count:" + exceptions.size());
            }
        }
    }

    @Override
    public void notifyStatusConfirm(final StatusConfirmRequest statusConfirmRequest) {
        try {
            NodeConnectManager nodeConnectManager = this.getNodeConnectManager();
            Collection<InetSocketAddress> connections = nodeConnectManager.getConnections(null);
            for (final InetSocketAddress address : connections) {
                if (!address.getAddress().getHostAddress().equals(statusConfirmRequest.getNode().getNodeUrl().getIpAddress())) continue;
                Request<StatusConfirmRequest> statusConfirmRequestRequest = new Request<StatusConfirmRequest>(){

                    public StatusConfirmRequest getRequestBody() {
                        return statusConfirmRequest;
                    }

                    public URL getRequestUrl() {
                        return new URL(address);
                    }
                };
                this.dataNodeExchanger.request((Request)statusConfirmRequestRequest);
                break;
            }
        }
        catch (RequestException e) {
            LOGGER.error("Notify status confirm error! " + e.getRequestMessage(), (Throwable)e);
            throw new RuntimeException("Notify status confirm error! ", e);
        }
    }

    private void confirmStatus(InetSocketAddress address, String confirmNodeIp) {
        String ipAddress = address.getAddress().getHostAddress();
        this.dataStoreService.confirmNodeStatus(ipAddress, confirmNodeIp);
    }

    private NodeConnectManager getNodeConnectManager() {
        if (!(this.dataConnectionHandler instanceof NodeConnectManager)) {
            LOGGER.error("dataConnectionHandler inject is not NodeConnectManager instance!");
            throw new RuntimeException("dataConnectionHandler inject is not NodeConnectManager instance!");
        }
        return (NodeConnectManager)((Object)this.dataConnectionHandler);
    }
}

