/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.connection;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.RemotingException;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.remoting.connection.NodeConnectManager;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class MetaConnectionHandler
extends AbstractServerHandler
implements NodeConnectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaConnectionHandler.class);
    @Autowired
    private NodeConfig nodeConfig;
    private Map<String, Map<String, InetSocketAddress>> connections = new ConcurrentHashMap<String, Map<String, InetSocketAddress>>();

    @Override
    public void connected(Channel channel) throws RemotingException {
        super.connected(channel);
        this.addConnection(channel);
    }

    @Override
    public void disconnected(Channel channel) throws RemotingException {
        super.disconnected(channel);
        this.removeConnection(channel);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.LISENTER;
    }

    @Override
    public void addConnection(Channel channel) {
        InetSocketAddress remoteAddress = channel.getRemoteAddress();
        String connectId = NetUtil.toAddressString((InetSocketAddress)remoteAddress);
        String ipAddress = remoteAddress.getAddress().getHostAddress();
        String dataCenter = this.nodeConfig.getMetaDataCenter(ipAddress);
        if (dataCenter != null) {
            ConcurrentHashMap<String, InetSocketAddress> newMap;
            ConcurrentHashMap<String, InetSocketAddress> connectMap = this.connections.get(dataCenter);
            if (connectMap == null && (connectMap = (ConcurrentHashMap<String, InetSocketAddress>)this.connections.putIfAbsent(dataCenter, newMap = new ConcurrentHashMap<String, InetSocketAddress>())) == null) {
                connectMap = newMap;
            }
            connectMap.putIfAbsent(connectId, remoteAddress);
        }
    }

    @Override
    public boolean removeConnection(Channel channel) {
        Map<String, InetSocketAddress> connectMap;
        InetSocketAddress remoteAddress = channel.getRemoteAddress();
        String connectId = NetUtil.toAddressString((InetSocketAddress)remoteAddress);
        String ipAddress = remoteAddress.getAddress().getHostAddress();
        String dataCenter = this.nodeConfig.getMetaDataCenter(ipAddress);
        if (dataCenter != null && (connectMap = this.connections.get(dataCenter)) != null) {
            connectMap.remove(connectId);
            return true;
        }
        return false;
    }

    @Override
    public Collection<InetSocketAddress> getConnections(String dataCenter) {
        Map<String, InetSocketAddress> connectMap = this.connections.get(dataCenter);
        if (connectMap == null || connectMap.isEmpty()) {
            LOGGER.error("Can not find connection of dataCenter {}", (Object)dataCenter);
            throw new RuntimeException("Can not find connection of dataCenter:" + dataCenter);
        }
        return connectMap.values();
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.META;
    }
}

