/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.ReNewNodesRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class ReNewNodesRequestHandler
extends AbstractServerHandler<ReNewNodesRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReNewNodesRequestHandler.class);
    @Autowired
    private Registry metaServerRegistry;

    @Override
    public Object reply(Channel channel, ReNewNodesRequest reNewNodesRequest) {
        Node reNewNode = null;
        try {
            reNewNode = reNewNodesRequest.getNode();
            this.metaServerRegistry.reNew(reNewNode, reNewNodesRequest.getDuration());
        }
        catch (Exception e) {
            LOGGER.error("Node " + reNewNode + "reNew error!", (Throwable)e);
            throw new RuntimeException("Node reNew error!", e);
        }
        return null;
    }

    @Override
    public Class interest() {
        return ReNewNodesRequest.class;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }
}

