/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.handler;

import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.SessionNode;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionNodeHandler
extends AbstractServerHandler<SessionNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionNodeHandler.class);
    @Autowired
    private Registry metaServerRegistry;

    @Override
    public Object reply(Channel channel, SessionNode sessionNode) {
        NodeChangeResult nodeChangeResult;
        try {
            nodeChangeResult = this.metaServerRegistry.register(sessionNode);
            LOGGER.info("Session node {} register success!", (Object)sessionNode);
        }
        catch (Exception e) {
            LOGGER.error("Session node register error!", (Throwable)e);
            throw new RuntimeException("Session node register error!", e);
        }
        return nodeChangeResult;
    }

    @Override
    public Class interest() {
        return SessionNode.class;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }
}

