/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.LocalFileConfigurator;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcProperties;
import com.alipay.sofa.rpc.boot.config.ZookeeperConfigurator;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;

public class RegistryConfigContainer {
    private SofaBootRpcProperties sofaBootRpcProperties;
    private ZookeeperConfigurator zookeeperConfigurator;
    private LocalFileConfigurator localFileConfigurator;
    private volatile RegistryConfig localRegistryConfig;
    private volatile RegistryConfig zookeeperRegistryConfig;

    public RegistryConfigContainer(SofaBootRpcProperties sofaBootRpcProperties, ZookeeperConfigurator zookeeperConfigurator, LocalFileConfigurator localFileConfigurator) {
        this.sofaBootRpcProperties = sofaBootRpcProperties;
        this.zookeeperConfigurator = zookeeperConfigurator;
        this.localFileConfigurator = localFileConfigurator;
    }

    public Registry getRegistry() {
        Registry registry = RegistryFactory.getRegistry((RegistryConfig)this.getRegistryConfig());
        registry.init();
        registry.start();
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RegistryConfig getRegistryConfig() throws SofaBootRpcRuntimeException {
        String registryConfig = this.sofaBootRpcProperties.getRegistryAddress();
        if (StringUtils.isBlank((CharSequence)registryConfig) || registryConfig.startsWith("local")) {
            if (this.localRegistryConfig != null) return this.localRegistryConfig;
            Class<RegistryConfigContainer> clazz = RegistryConfigContainer.class;
            synchronized (RegistryConfigContainer.class) {
                if (this.localRegistryConfig != null) return this.localRegistryConfig;
                this.localRegistryConfig = this.createLocalRegistryConfig();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.localRegistryConfig;
            }
        }
        if (!registryConfig.startsWith("zookeeper")) throw new SofaBootRpcRuntimeException("protocol[" + registryConfig + "] is not supported");
        if (this.zookeeperRegistryConfig != null) return this.zookeeperRegistryConfig;
        Class<RegistryConfigContainer> clazz = RegistryConfigContainer.class;
        synchronized (RegistryConfigContainer.class) {
            if (this.zookeeperRegistryConfig != null) return this.zookeeperRegistryConfig;
            this.zookeeperRegistryConfig = this.createZookeeperRegistryConfig();
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return this.zookeeperRegistryConfig;
        }
    }

    RegistryConfig createLocalRegistryConfig() {
        this.localFileConfigurator.parseConfig();
        String filePath = this.localFileConfigurator.getFile();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            filePath = SofaBootRpcConfigConstants.REGISTRY_FILE_PATH_DEFAULT;
        }
        return new RegistryConfig().setFile(filePath).setProtocol("local");
    }

    public RegistryConfig createZookeeperRegistryConfig() {
        this.zookeeperConfigurator.parseConfig();
        String address = this.zookeeperConfigurator.getAddress();
        String filePath = this.zookeeperConfigurator.getFile();
        return new RegistryConfig().setAddress(address).setFile(filePath).setProtocol("zookeeper");
    }

    public void removeAllRegistryConfig() {
        this.localRegistryConfig = null;
        this.zookeeperRegistryConfig = null;
    }
}

