/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.converter;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcParserUtil;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcSpringUtil;
import com.alipay.sofa.rpc.boot.container.RpcFilterContainer;
import com.alipay.sofa.rpc.boot.runtime.binding.BoltBinding;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBindingMethodInfo;
import com.alipay.sofa.rpc.boot.runtime.param.BoltBindingParam;
import com.alipay.sofa.rpc.boot.runtime.param.RpcBindingParam;
import com.alipay.sofa.rpc.config.UserThreadPoolManager;
import com.alipay.sofa.rpc.filter.ExcludeFilter;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.server.UserThreadPool;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.api.annotation.SofaReferenceBinding;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class RpcBindingConverter
implements BindingConverter<RpcBindingParam, RpcBinding> {
    private static final String FILTER_SEPERATOR_SYMBOL = ",";
    private static final char EXCLUDE_FILTER_BEGIN_SYMBOL = '!';

    public RpcBinding convert(RpcBindingParam bindingParam, BindingConverterContext bindingConverterContext) {
        RpcBinding binding = this.createRpcBinding(bindingParam, bindingConverterContext.getApplicationContext(), bindingConverterContext.isInBinding());
        this.setCallback(bindingParam, bindingConverterContext);
        binding.setAppName(bindingConverterContext.getAppName());
        binding.setBeanId(bindingConverterContext.getBeanId());
        return binding;
    }

    public RpcBinding convert(Element element, BindingConverterContext bindingConverterContext) {
        RpcBindingParam param = this.createRpcBindingParam();
        Element globalAttrsElement = DomUtils.getChildElementByTagName((Element)element, (String)"global-attrs");
        Element routeElement = DomUtils.getChildElementByTagName((Element)element, (String)"route");
        List methodElements = DomUtils.getChildElementsByTagName((Element)element, (String)"method");
        this.parseGlobalAttrs(globalAttrsElement, param, bindingConverterContext);
        this.parseFilter(globalAttrsElement, param, bindingConverterContext);
        this.parseMethod(methodElements, param);
        this.parseRoute(routeElement, param);
        return this.convert(param, bindingConverterContext);
    }

    protected abstract RpcBinding createRpcBinding(RpcBindingParam var1, ApplicationContext var2, boolean var3);

    protected abstract RpcBindingParam createRpcBindingParam();

    private void parseMethod(List<Element> elements, RpcBindingParam param) {
        if (CollectionUtils.isEmpty(elements)) {
            return;
        }
        ArrayList<RpcBindingMethodInfo> boltBindingMethodInfos = new ArrayList<RpcBindingMethodInfo>();
        for (Element element : elements) {
            if (element.getNodeType() != 1 || !element.getLocalName().equals("method")) continue;
            String name = element.getAttribute("name");
            Integer timeout = SofaBootRpcParserUtil.parseInteger(element.getAttribute("timeout"));
            Integer retries = SofaBootRpcParserUtil.parseInteger(element.getAttribute("retries"));
            String type = element.getAttribute("type");
            RpcBindingMethodInfo boltBindingMethodInfo = new RpcBindingMethodInfo();
            if (StringUtils.hasText((String)name)) {
                boltBindingMethodInfo.setName(name);
            }
            if (timeout != null) {
                boltBindingMethodInfo.setTimeout(timeout);
            }
            if (retries != null) {
                boltBindingMethodInfo.setRetries(retries);
            }
            if (StringUtils.hasText((String)type)) {
                boltBindingMethodInfo.setType(type);
            }
            if (type.equalsIgnoreCase("callback")) {
                String callbackRef = element.getAttribute("callback-ref");
                String callbackClass = element.getAttribute("callback-class");
                boltBindingMethodInfo.setCallbackRef(callbackRef);
                boltBindingMethodInfo.setCallbackClass(callbackClass);
            }
            boltBindingMethodInfos.add(boltBindingMethodInfo);
        }
        param.setMethodInfos(boltBindingMethodInfos);
    }

    private void parseGlobalAttrs(Element element, RpcBindingParam param, BindingConverterContext bindingConverterContext) {
        if (element == null) {
            return;
        }
        Integer timeout = SofaBootRpcParserUtil.parseInteger(element.getAttribute("timeout"));
        Integer addressWaitTime = SofaBootRpcParserUtil.parseInteger(element.getAttribute("address-wait-time"));
        Integer connectTimeout = SofaBootRpcParserUtil.parseInteger(element.getAttribute("connect.timeout"));
        Integer retries = SofaBootRpcParserUtil.parseInteger(element.getAttribute("retries"));
        String type = element.getAttribute("type");
        String callbackClass = element.getAttribute("callback-class");
        String callbackRef = element.getAttribute("callback-ref");
        Integer weight = SofaBootRpcParserUtil.parseInteger(element.getAttribute("weight"));
        Integer warmUpTime = SofaBootRpcParserUtil.parseInteger(element.getAttribute("warm-up-time"));
        Integer warmUpWeight = SofaBootRpcParserUtil.parseInteger(element.getAttribute("warm-up-weight"));
        Object treadPoolRef = SofaBootRpcSpringUtil.getSpringBean(element.getAttribute("thread-pool-ref"), bindingConverterContext.getApplicationContext(), bindingConverterContext.getAppClassLoader(), bindingConverterContext.getAppName());
        String genericInterface = element.getAttribute("generic-interface");
        String loadBalancer = element.getAttribute("loadBalancer");
        Boolean lazy = SofaBootRpcParserUtil.parseBoolean(element.getAttribute("lazy"));
        Boolean check = SofaBootRpcParserUtil.parseBoolean(element.getAttribute("check"));
        String serialization = element.getAttribute("serialize-type");
        if (timeout != null) {
            param.setTimeout(timeout);
        }
        if (addressWaitTime != null) {
            param.setAddressWaitTime(addressWaitTime);
        }
        if (connectTimeout != null) {
            param.setConnectTimeout(connectTimeout);
        }
        if (retries != null) {
            param.setRetries(retries);
        }
        if (StringUtils.hasText((String)type)) {
            param.setType(type);
        }
        if (StringUtils.hasText((String)callbackClass)) {
            param.setCallbackClass(callbackClass);
        }
        if (StringUtils.hasText((String)callbackRef)) {
            param.setCallbackRef(callbackRef);
        }
        if (weight != null) {
            param.setWeight(weight);
        }
        if (warmUpTime != null) {
            param.setWarmUpTime(warmUpTime);
        }
        if (warmUpWeight != null) {
            param.setWarmUpWeight(warmUpWeight);
        }
        if (treadPoolRef != null) {
            param.setUserThreadPool((UserThreadPool)treadPoolRef);
        }
        if (StringUtils.hasText((String)genericInterface)) {
            param.setGenericInterface(genericInterface);
        }
        if (StringUtils.hasText((String)loadBalancer)) {
            param.setLoadBalancer(loadBalancer);
        }
        if (lazy != null) {
            param.setLazy(lazy);
        }
        if (check != null) {
            param.setCheck(check);
        }
        if (StringUtils.hasText((String)serialization)) {
            param.setSerialization(serialization);
        }
    }

    private void parseFilter(Element element, RpcBindingParam param, BindingConverterContext bindingConverterContext) {
        ArrayList<Filter> filters = new ArrayList<Filter>(RpcFilterContainer.getInstance().getFilters(bindingConverterContext.getApplicationContext()));
        if (element != null) {
            ArrayList<String> filterNames = new ArrayList<String>();
            String filterStrs = element.getAttribute("filter");
            if (StringUtils.hasText((String)filterStrs)) {
                String[] subFilter;
                for (String subfilterName : subFilter = filterStrs.split(FILTER_SEPERATOR_SYMBOL)) {
                    if (!StringUtils.hasText((String)subfilterName)) continue;
                    if (subfilterName.charAt(0) == '!') {
                        String realFilterName = subfilterName.substring(1);
                        if (!StringUtils.hasText((String)realFilterName)) continue;
                        filters.add((Filter)new ExcludeFilter(realFilterName));
                        continue;
                    }
                    filterNames.add(subfilterName);
                }
            }
            if (!CollectionUtils.isEmpty(filterNames)) {
                for (String filterName : filterNames) {
                    Object filter = bindingConverterContext.getApplicationContext().getBean(filterName);
                    if (filter instanceof Filter) {
                        filters.add((Filter)filter);
                        continue;
                    }
                    throw new SofaBootRpcRuntimeException("filter name[" + filterName + "] is not ref a Filter.");
                }
            }
        }
        param.setFilters(filters);
    }

    private void parseRoute(Element routeElement, RpcBindingParam param) {
        if (routeElement == null) {
            return;
        }
        String targetUrl = routeElement.getAttribute("target-url");
        if (StringUtils.hasText((String)targetUrl)) {
            param.setTargetUrl(targetUrl);
        }
    }

    private void setCallback(RpcBindingParam bindingParam, BindingConverterContext bindingConverterContext) {
        Object globalCallbackHandler;
        if (bindingParam.getCallbackHandler() == null && (globalCallbackHandler = SofaBootRpcSpringUtil.getSpringBean(bindingParam.getCallbackRef(), bindingParam.getCallbackClass(), bindingConverterContext.getApplicationContext(), bindingConverterContext.getAppClassLoader(), bindingConverterContext.getAppName())) != null) {
            bindingParam.setCallbackHandler(globalCallbackHandler);
        }
        if (!CollectionUtils.isEmpty(bindingParam.getMethodInfos())) {
            for (RpcBindingMethodInfo methodInfo : bindingParam.getMethodInfos()) {
                Object methodCallbackHandler = methodInfo.getCallbackHandler();
                if (methodCallbackHandler != null) continue;
                methodCallbackHandler = SofaBootRpcSpringUtil.getSpringBean(methodInfo.getCallbackRef(), methodInfo.getCallbackClass(), bindingConverterContext.getApplicationContext(), bindingConverterContext.getAppClassLoader(), bindingConverterContext.getAppName());
                methodInfo.setCallbackHandler(methodCallbackHandler);
            }
        }
    }

    public RpcBinding convert(SofaService sofaServiceAnnotation, SofaServiceBinding sofaServiceBindingAnnotation, BindingConverterContext bindingConverterContext) {
        String threadPool;
        BoltBindingParam bindingParam = new BoltBindingParam();
        bindingParam.setTimeout(sofaServiceBindingAnnotation.timeout());
        if (sofaServiceBindingAnnotation.weight() != 0) {
            bindingParam.setWeight(sofaServiceBindingAnnotation.weight());
        }
        if (sofaServiceBindingAnnotation.warmUpTime() != 0) {
            bindingParam.setWarmUpTime(sofaServiceBindingAnnotation.warmUpTime());
        }
        if (sofaServiceBindingAnnotation.warmUpWeight() != 0) {
            bindingParam.setWarmUpWeight(sofaServiceBindingAnnotation.warmUpWeight());
        }
        ApplicationContext applicationContext = bindingConverterContext.getApplicationContext();
        ArrayList<Filter> filters = new ArrayList<Filter>(RpcFilterContainer.getInstance().getFilters(applicationContext));
        String[] filterNames = sofaServiceBindingAnnotation.filters();
        if (filterNames.length > 0) {
            for (String filterName : filterNames) {
                Object filter = applicationContext.getBean(filterName);
                if (!(filter instanceof Filter)) {
                    throw new SofaBootRpcRuntimeException("filter name[" + filterName + "] is not ref a Filter.");
                }
                filters.add((Filter)filter);
            }
        }
        if (!CollectionUtils.isEmpty(filters)) {
            bindingParam.setFilters(filters);
        }
        if (StringUtils.hasText((String)(threadPool = sofaServiceBindingAnnotation.userThreadPool()))) {
            UserThreadPool threadPoolObj = (UserThreadPool)applicationContext.getBean(threadPool);
            String interfaceName = sofaServiceAnnotation.interfaceType().getCanonicalName();
            String uniqId = sofaServiceAnnotation.uniqueId();
            String uniqueName = interfaceName + ":1.0" + (StringUtils.isEmpty((Object)uniqId) ? "" : ":" + uniqId);
            UserThreadPoolManager.registerUserThread((String)uniqueName, (UserThreadPool)threadPoolObj);
        }
        return new BoltBinding(bindingParam, bindingConverterContext.getApplicationContext(), bindingConverterContext.isInBinding());
    }

    public RpcBinding convert(SofaReference sofaReferenceAnnotation, SofaReferenceBinding sofaReferenceBindingAnnotation, BindingConverterContext bindingConverterContext) {
        BoltBindingParam bindingParam = new BoltBindingParam();
        if (sofaReferenceBindingAnnotation.addressWaitTime() != 0) {
            bindingParam.setAddressWaitTime(sofaReferenceBindingAnnotation.addressWaitTime());
        }
        if (StringUtils.hasText((String)sofaReferenceBindingAnnotation.directUrl())) {
            bindingParam.setTargetUrl(sofaReferenceBindingAnnotation.directUrl());
        }
        if (sofaReferenceBindingAnnotation.timeout() != 0) {
            bindingParam.setTimeout(sofaReferenceBindingAnnotation.timeout());
        }
        bindingParam.setType(sofaReferenceBindingAnnotation.bindingType());
        ApplicationContext applicationContext = bindingConverterContext.getApplicationContext();
        ArrayList<Filter> filters = new ArrayList<Filter>(RpcFilterContainer.getInstance().getFilters(applicationContext));
        String[] filterNames = sofaReferenceBindingAnnotation.filters();
        if (filterNames.length > 0) {
            for (String filterName : filterNames) {
                Object filter = applicationContext.getBean(filterName);
                if (!(filter instanceof Filter)) {
                    throw new SofaBootRpcRuntimeException("filter name[" + filterName + "] is not ref a Filter.");
                }
                filters.add((Filter)filter);
            }
        }
        if (!CollectionUtils.isEmpty(filters)) {
            bindingParam.setFilters(filters);
        }
        bindingParam.setRetries(sofaReferenceBindingAnnotation.retries());
        String callbackRef = sofaReferenceBindingAnnotation.callbackHandler();
        if (StringUtils.hasText((String)callbackRef)) {
            bindingParam.setCallbackHandler(applicationContext.getBean(callbackRef));
        }
        bindingParam.setLazy(sofaReferenceBindingAnnotation.lazy());
        return new BoltBinding(bindingParam, bindingConverterContext.getApplicationContext(), bindingConverterContext.isInBinding());
    }
}

